/*
 * Decompiled with CFR 0.152.
 */
package provider.trdsp.service.config;

import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import provider.trdsp.api.TrdspApi;
import provider.trdsp.vo.BasicVo;

@Component
@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    TrdspApi trdspApi;

    @Pointcut(value="execution(* provider.trdsp.service.apiImpl.TrdspApiImpl.*(*,java.lang.String))")
    public void callTrdspApi() {
    }

    @Around(value="callTrdspApi()")
    public Object showLog(ProceedingJoinPoint point) {
        Object[] args = point.getArgs();
        String storeId = (String)args[1];
        List<Object> asList = Arrays.asList(args);
        Signature signature = point.getSignature();
        String name = signature.getName();
        Object result = null;
        try {
            BasicVo bv;
            result = point.proceed(args);
            if (result instanceof BasicVo && "110014".equals((bv = (BasicVo)result).getResultCode())) {
                log.info("---inner invoke {}{}{} ", new Object[]{bv.getResultCode(), bv.getResultMessage(), bv.getSuccess()});
                this.trdspApi.getTokenFromTrdSp(storeId);
                log.info("---inner invoke \u91cd\u65b0\u83b7\u53d6token");
                result = point.proceed(args);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

