/*
 * Decompiled with CFR 0.152.
 */
package provider.trdsp.service.service;

import cart.api.exception.BusinessException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Service;
import provider.trdsp.model.po.TrdSpInfo;
import provider.trdsp.model.repository.TrdSpInfoRepos;
import provider.trdsp.model.repository.TrdSpUrlRepos;
import utils.Lang;

@Service
public class TrdSpUrlService {
    @Autowired
    private TrdSpUrlRepos trdSpUrlRepos;
    @Autowired
    private TrdSpInfoRepos trdSpInfoRepos;
    private RedisTemplate redisTemplate;

    @Autowired
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate = redisTemplate;
    }

    public TrdSpInfo getTrdSpInfoByStoreId(String storeId) {
        String key = "TrdspInfo" + storeId;
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        if (boundValueOperations.get() != null) {
            TrdSpInfo trdSpInfo = (TrdSpInfo)boundValueOperations.get();
            return trdSpInfo;
        }
        TrdSpInfo trdSpInfo = this.trdSpInfoRepos.findByStoreId(storeId);
        if (Lang.isEmpty((Object)trdSpInfo)) {
            throw new BusinessException("\u627e\u4e0d\u5230\u4e09\u65b9\u4f9b\u5e94\u5546\u7684\u4fe1\u606f");
        }
        boundValueOperations.set((Object)trdSpInfo, 12L, TimeUnit.MINUTES);
        return trdSpInfo;
    }
}

