package recharge.center.api.emay.api.definition;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 错误代码
 *
 * @author Drury
 * @date 2018/6/12
 */
@Data
public class ErrorInfo {

    /**
     * 超时
     */
    public static final String TIME_OUT = "TIME_OUT";

    /**
     * 错误代码描述MAP集合
     */
    public final static Map<String, String> ERRORS = new HashMap<>();


    static {
        // 提交错误码
        ERRORS.put("ERROR_PRODUCT", "产品错误");
        ERRORS.put("ERROR_APPID", "AppId不存在");
        ERRORS.put("ERROR_PARAMS", "请求参数错误");
        ERRORS.put("ERROR_CLIENT_IP", "不识别的Ip");
        ERRORS.put("ERROR_CUSTOM_TASKNO", "客户生成的订单号超长");
        ERRORS.put("ERROR_SIGN", "签名错误");
        ERRORS.put("ERROR_MOBILE_EMPTY", "手机号码为空");
        ERRORS.put("ERROR_MOBILE", "手机号码错误");
        ERRORS.put("ERROR_BALANCE", "余额不足");
        ERRORS.put("ERROR_UNKNOW", "未知失败");
        ERRORS.put("ERROR_NOTASK", "没有此订单");
        ERRORS.put("ERROR_QUERY_FAST", "查询频率过快");
        ERRORS.put("ERROR_SERVICECODE_STATE", "服务号停用");

        // 状态报告响应码
        ERRORS.put("FAIL_BALANCE", "余额不足");
        ERRORS.put("FAIL_CACHE", "订单缓存");
        ERRORS.put("FAIL_RESPONSE", "运营商响应失败");
        ERRORS.put("FAIL_SERVICECODE", "服务号不存在");
        ERRORS.put("FAIL_CHANNEL_DISCONNECT", "未找到通道折扣");
        ERRORS.put("FAIL_CLIENT_DISCONNECT", "未找到客户折扣");
        ERRORS.put("FAIL_CHARGING", "扣费失败");
        ERRORS.put("FAIL_PRICE", "价格配置不符");
        ERRORS.put("FAIL_CACHE_TIMEOUT", "缓存超时");
        ERRORS.put("FAIL_CHANNEL_SUPPORT", "当前通道不支持");
        ERRORS.put("FAIL_ROUTE", "路由失败");
    }

}
