package recharge.center.api.emay.api.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 亿美订单请求对象
 *
 * @author ChengHaiTao
 */
@Data
public class OrderEntity implements Serializable {

    /**
     * 手机号列表，必填
     */
    private String mobile;

    /**
     * 由客户产生的此订单编号，不能超过64位
     */
    private String clientTaskNo;

    /**
     * 我方流量编码，如M5，T1024，U20。采用英文缩写+包型大小的方式生成。
     * 编码生成策略：M代表中国移动，T代表中国电信，U代表中国联通，数字是流量包型大小。
     * 10M是10，1g是1024，以此类推。
     */
    private String productCode;

}
