package recharge.center.api.emay.api.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 亿美订单响应对象
 *
 * @author ChengHaiTao
 */
@Data
public class OrderResp implements Serializable {

    /**
     * 由客户产生的此订单编号，不能超过64位
     */
    private String clientTaskNo;

    /**
     * 此次请求的状态码，SUCCESS是接收成功，其余均为接收不成功。
     * 如果请求成功,必然生成我方订单号，平台单号的产生,并不意味充值成功,只表明平台已接收请求.
     * 当responseCode等于SUCCESS的时候，表示下单成功，其他情况下根据不同情况是不同的错误码.
     */
    private String responseCode;

    /**
     * 我司订单编号，用来查询订单状态
     */
    private String taskNo;

}
