package recharge.center.api.weineng.api.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 微能订单请求对象
 *
 * @author ChengHaiTao
 */
@Data
public class OrderEntity implements Serializable {

    /**
     * 请求时间戳(必填）
     */
    private String submitTimestamp;

    /**
     * 卡券批次号(必填）
     */
    private String cardBatchNo;

    /**
     * 换购订单号(必填）
     */
    private String orderId;

    /**
     * 客户识别号(必填）
     */
    private String customerNo;

    /**
     * 换购数量(必填）
     */
    private int orderQuantity;

    /**
     * 换购时间(必填）
     */
    private String orderTime;

    /**
     * 换购积分数(必填）扣除采购商的积分或者其他货品数量，采购商没有积分业务则传订购数量
     */
    private int orderPoints;

    /**
     * 换购总金额(非必填）
     */
    private int orderPrice;

    /**
     * 用户来自哪个省(非必填）
     */
    private String provUser;

    /**
     * 使用目的地省份(非必填）
     */
    private String provUse;

}
