package recharge.center.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import recharge.center.api.weineng.api.request.ContractBalanceEntity;
import recharge.center.api.weineng.api.request.OrderEntity;
import recharge.center.api.weineng.api.response.ContractBalanceResp;
import recharge.center.api.weineng.api.response.OrderResp;
import recharge.center.api.weineng.api.service.RechargeWeiNengApi;
import recharge.center.service.config.weineng.WebWnClient;
import recharge.center.service.config.yimei.ProtocolUntil;

import java.util.LinkedHashMap;

/**
 * @author bande
 * @date 2018/6/4
 */
@Slf4j
@MotanService
public class RechargeWeiNengApiImpl implements RechargeWeiNengApi {

    @Value("${weinneng.pid}")
    String pid;

    @Value("${weinneng.word}")
    String password;

    @Value("${weinneng.http}")
    String http;


    @Override
    public OrderResp getOrderCard(OrderEntity orderEntity) {
        log.info("请求 : {}", JSON.toJSONString(orderEntity));
        String resp = null;
        LinkedHashMap<String, String> map = new LinkedHashMap<>();
        // 请求时间戳
        map.put("submitTimestamp", orderEntity.getSubmitTimestamp());
        map.put("pid", pid);
        map.put("cardBatchNo", orderEntity.getCardBatchNo());
        map.put("password", password);
        map.put("orderId", orderEntity.getOrderId());
        map.put("customerNo", orderEntity.getCustomerNo());
        // 换购数量
        map.put("orderQuantity", String.valueOf(orderEntity.getOrderQuantity()));
        // 换购时间,YYYYMMDDHH24MISS
        map.put("orderTime", orderEntity.getOrderTime());
        // 换购积分数
        map.put("orderPoints", String.valueOf(orderEntity.getOrderPoints()));
        //换购总金额
        map.put("orderPrice", String.valueOf(orderEntity.getOrderPrice()));
        try {
            String md5 = ProtocolUntil.getSignMd5(map);
            // 生成signMsg
            map.put("signMsg", md5);
            // 请求url中不需传递password参数
            map.remove("password");
            // 生成url
            String url = http + "!order.do?" + ProtocolUntil.getURL(map);
            // 获得http请求的反馈
            resp = webClient.retrieveWebContent(url);

            log.info("响应数据 : {}", resp);

        } catch (Exception e) {
            log.error("调用微能接口异常", e);
        }
        // 返回json格式的对象
        OrderResp orderResp = JSON.parseObject(resp, OrderResp.class);
        log.info("返回对象数据 : {}", JSON.toJSONString(orderResp));
        return orderResp;
    }

    @Override
    public ContractBalanceResp getContractBalance(ContractBalanceEntity contractBalanceEntity) {
        return new ContractBalanceResp();
    }

    private final WebWnClient webClient;

    @Autowired
    public RechargeWeiNengApiImpl(WebWnClient webClient) {
        this.webClient = webClient;
    }
}

