package recharge.center.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import recharge.center.api.emay.api.definition.ErrorInfo;
import recharge.center.api.emay.api.request.OrderEntity;
import recharge.center.api.emay.api.request.OrderQueryEntity;
import recharge.center.api.emay.api.response.EmBalanceQueryResp;
import recharge.center.api.emay.api.response.OrderQueryResp;
import recharge.center.api.emay.api.response.OrderResp;
import recharge.center.api.emay.api.service.RechargeYiMeiApi;
import recharge.center.service.config.yimei.*;
import recharge.center.service.config.yimei.HttpClient.HttpMethod;

/**
 * @author bande
 * @date 2018/6/4
 */
@Slf4j
@MotanService
public class RechargeYiMeiApiImpl implements RechargeYiMeiApi {

    /**
     * 接口 token
     */
    @Value("${yimei.token}")
    private String token;

    /**
     * 接口 appId
     */
    @Value("${yimei.appId}")
    private String appId;

    /**
     * 下单接口地址
     */
    @Value("${yimeiorder.url}")
    private String url;


    /**
     * 订单查询接口地址
     */
    @Value("${yimeiqueryorder.url}")
    private String queryOrderUrl;


    /**
     * 余额查询接口地址
     */
    @Value("${yimeiquerybalance.url}")
    private String queryBalanceUrl;

    /**
     * 代理地址
     */
    @Value("${proxy.host}")
    private String proxyHost;

    /**
     * 代理端口
     */
    @Value("${proxy.port}")
    private String proxyPort;

    /**
     * 当前环境配置
     */
    @Value("${spring.profiles.active}")
    private String activeEnv;

    private static final String UAT = "uat";

    @Override
    public OrderResp getEmOrder(OrderEntity orderEntity) {
        log.info("请求 : {}", JSON.toJSONString(orderEntity));
        String sign = ("appId=" + appId) + "&mobile=" + orderEntity.getMobile() +
                "&clientTaskNo=" + orderEntity.getClientTaskNo() + "&productCode=" + orderEntity.getProductCode();
        //key值 MD5加密
        String signReq = EMayEncryptionUntil.md5(sign + token);
        String reqStr = ("appId=" + appId) + "&mobile=" + orderEntity.getMobile() +
                "&clientTaskNo=" + orderEntity.getClientTaskNo() + "&productCode=" + orderEntity.getProductCode() + "&sign=" + signReq;

        HttpClient client = new HttpClient(20, 20, true);
        HttpRequestBody body = null;
        try {
            body = new HttpRequestBody(url, "UTF-8", reqStr, HttpMethod.POST, null, null);
        } catch (HttpErrorException e) {
            log.error("封装请求参数异常", e);
        }

        HttpResponseBody res;
        if (activeEnv.contains(UAT)) {
            res = client.serviceProxy(body, proxyHost, Integer.valueOf(proxyPort));
        } else {
            res = client.service(body);
        }
        log.info("响应数据 : {}", JSON.toJSONString(res));

        String rs = null;
        if (res.isSuccess()) {
            rs = res.getResultString();
            log.info("getResultString : {}", rs);
        }

        OrderResp orderResp = JSON.parseObject(rs, OrderResp.class);
        log.info("方法返回数据 : {}", JSON.toJSONString(orderResp));
        return orderResp;
    }

    @Override
    public OrderQueryResp queryEmOrder(OrderQueryEntity orderQueryEntity) {
        log.info("请求 : {}", JSON.toJSONString(orderQueryEntity));
        String sign = ("appId=" + appId) + "&taskNo=" + orderQueryEntity.getTaskNo() + "&clientTaskNo=" + orderQueryEntity.getClientTaskNo();
        String signReq = EMayEncryptionUntil.md5(sign + token);
        String reqStr = ("appId=" + appId) + "&taskNo=" + orderQueryEntity.getTaskNo() + "&clientTaskNo=" + orderQueryEntity.getClientTaskNo() + "&sign=" + signReq;
        HttpClient client = new HttpClient(10, 10, true);
        HttpRequestBody body = null;
        try {
            body = new HttpRequestBody(queryOrderUrl, "UTF-8", reqStr,
                    HttpMethod.POST, null, null);
        } catch (HttpErrorException e) {
            log.error("HttpErrorException", e);
        }

        HttpResponseBody res;
        if (activeEnv.contains(UAT)) {
            res = client.serviceProxy(body, proxyHost, Integer.valueOf(proxyPort));
        } else {
            res = client.service(body);
        }
        log.info("响应 : {}", JSON.toJSONString(res));

        if (res.getCode() == -1) {
            return new OrderQueryResp(null, null, ErrorInfo.TIME_OUT);
        }

        String rs = null;
        if (res.isSuccess()) {
            rs = res.getResultString();
            log.info("getResultString : {}", rs);
        }

        OrderQueryResp orderQueryResp = JSON.parseObject(rs, OrderQueryResp.class);
        log.info("方法返回数据 : {}", JSON.toJSONString(orderQueryResp));
        return orderQueryResp;
    }

    @Override
    public EmBalanceQueryResp queryEmOrderBalance() {
        String sign = ("appId=" + appId + token);
        String signReq = EMayEncryptionUntil.md5(sign);
        String reqStr = ("appId=" + appId) + "&sign=" + signReq;
        HttpClient client = new HttpClient(10, 10, true);
        HttpRequestBody body = null;
        try {
            body = new HttpRequestBody(queryBalanceUrl, "UTF-8", reqStr,
                    HttpMethod.POST, null, null);
        } catch (HttpErrorException e) {
            e.printStackTrace();
        }

        HttpResponseBody res;
        if (activeEnv.contains(UAT)) {
            res = client.serviceProxy(body, proxyHost, Integer.valueOf(proxyPort));
        } else {
            res = client.service(body);
        }
        log.info("响应 : {}", JSON.toJSONString(res));

        String rs = null;
        if (res.isSuccess()) {
            rs = res.getResultString();
            log.info("getResultString : {}", rs);
        }

        EmBalanceQueryResp emBalanceQueryResp = JSON.parseObject(rs, EmBalanceQueryResp.class);
        log.info("方法返回数据 : {}", JSON.toJSONString(emBalanceQueryResp));
        return emBalanceQueryResp;
    }
}
