package recharge.center.service.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import recharge.center.api.weineng.api.request.OrderEntity;
import recharge.center.api.weineng.api.response.OrderResp;
import recharge.center.api.weineng.api.service.RechargeWeiNengApi;
import utils.log.Log;
import utils.log.Logs;

@RestController
@RequestMapping("/recharge")
public class RechargeWeiNengController {
    private final static Log log = Logs.getLog(RechargeWeiNengController.class.getName());

    @Autowired
    RechargeWeiNengApi rechargeWeiNengApi;

    @RequestMapping("/testRechargeWeiNeng")
    public OrderResp getOrderCard(OrderEntity orderEntity){
        return rechargeWeiNengApi.getOrderCard(orderEntity);
    }
}
