package recharge.center.service.util.weineng;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.swift.util.http.WebClient;
import org.swift.util.http.WebClientManager;

/**
 * 重写微能 WebClient 类, 以便UAT环境能走代理访问接口地址
 *
 * @author Drury
 * @date 2018/6/21
 */
public class SinoWebClient extends WebClient {

    public static HttpClient getDefaultHttpClient() {
        HttpConnectionManager connectionManager = WebClientManager.getInstance().getHttpConnectionManager();
        HttpClientParams clientParams = WebClientManager.getInstance().getHttpClientParams();
        HttpClient httpClient = new HttpClient(clientParams, connectionManager);
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setProxy("10.94.210.96", 38080);
        httpClient.setHostConfiguration(hostConfiguration);
        return httpClient;
    }

    public static String retrieveWebContent(String url) {
        return retrieveWebContent(getDefaultHttpClient(), url);
    }

}
