/*
 * Decompiled with CFR 0.152.
 */
package recharge.center.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import recharge.center.api.weineng.api.request.ContractBalanceEntity;
import recharge.center.api.weineng.api.request.OrderEntity;
import recharge.center.api.weineng.api.response.ContractBalanceResp;
import recharge.center.api.weineng.api.response.OrderResp;
import recharge.center.api.weineng.api.service.RechargeWeiNengApi;
import recharge.center.service.config.weineng.WebWnClient;
import recharge.center.service.config.yimei.ProtocolUntil;

@MotanService
public class RechargeWeiNengApiImpl
implements RechargeWeiNengApi {
    private static final Logger log = LoggerFactory.getLogger(RechargeWeiNengApiImpl.class);
    @Value(value="${weinneng.pid}")
    String pid;
    @Value(value="${weinneng.word}")
    String password;
    @Value(value="${weinneng.http}")
    String http;
    private final WebWnClient webClient;

    public OrderResp getOrderCard(OrderEntity orderEntity) {
        log.info("\u8bf7\u6c42 : {}", (Object)JSON.toJSONString((Object)orderEntity));
        String resp = null;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("submitTimestamp", orderEntity.getSubmitTimestamp());
        map.put("pid", this.pid);
        map.put("cardBatchNo", orderEntity.getCardBatchNo());
        map.put("password", this.password);
        map.put("orderId", orderEntity.getOrderId());
        map.put("customerNo", orderEntity.getCustomerNo());
        map.put("orderQuantity", String.valueOf(orderEntity.getOrderQuantity()));
        map.put("orderTime", orderEntity.getOrderTime());
        map.put("orderPoints", String.valueOf(orderEntity.getOrderPoints()));
        map.put("orderPrice", String.valueOf(orderEntity.getOrderPrice()));
        try {
            String md5 = ProtocolUntil.getSignMd5(map);
            map.put("signMsg", md5);
            map.remove("password");
            String url = this.http + "!order.do?" + ProtocolUntil.getURL(map);
            resp = this.webClient.retrieveWebContent(url);
            log.info("\u54cd\u5e94\u6570\u636e : {}", (Object)resp);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u80fd\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        OrderResp orderResp = (OrderResp)JSON.parseObject(resp, OrderResp.class);
        log.info("\u8fd4\u56de\u5bf9\u8c61\u6570\u636e : {}", (Object)JSON.toJSONString((Object)orderResp));
        return orderResp;
    }

    public ContractBalanceResp getContractBalance(ContractBalanceEntity contractBalanceEntity) {
        return new ContractBalanceResp();
    }

    @Autowired
    public RechargeWeiNengApiImpl(WebWnClient webClient) {
        this.webClient = webClient;
    }
}

