/*
 * Decompiled with CFR 0.152.
 */
package recharge.center.service.apiImpl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import recharge.center.api.emay.api.request.OrderEntity;
import recharge.center.api.emay.api.request.OrderQueryEntity;
import recharge.center.api.emay.api.response.EmBalanceQueryResp;
import recharge.center.api.emay.api.response.OrderQueryResp;
import recharge.center.api.emay.api.response.OrderResp;
import recharge.center.api.emay.api.service.RechargeYiMeiApi;
import recharge.center.service.config.yimei.EMayEncryptionUntil;
import recharge.center.service.config.yimei.HttpClient;
import recharge.center.service.config.yimei.HttpErrorException;
import recharge.center.service.config.yimei.HttpRequestBody;
import recharge.center.service.config.yimei.HttpResponseBody;

@MotanService
public class RechargeYiMeiApiImpl
implements RechargeYiMeiApi {
    private static final Logger log = LoggerFactory.getLogger(RechargeYiMeiApiImpl.class);
    @Value(value="${yimei.token}")
    private String token;
    @Value(value="${yimei.appId}")
    private String appId;
    @Value(value="${yimeiorder.url}")
    private String url;
    @Value(value="${yimeiqueryorder.url}")
    private String queryOrderUrl;
    @Value(value="${yimeiquerybalance.url}")
    private String queryBalanceUrl;
    @Value(value="${proxy.host}")
    private String proxyHost;
    @Value(value="${proxy.port}")
    private String proxyPort;
    @Value(value="${spring.profiles.active}")
    private String activeEnv;
    private static final String UAT = "uat";

    public OrderResp getEmOrder(OrderEntity orderEntity) {
        log.info("\u8bf7\u6c42 : {}", (Object)JSON.toJSONString((Object)orderEntity));
        String sign = "appId=" + this.appId + "&mobile=" + orderEntity.getMobile() + "&clientTaskNo=" + orderEntity.getClientTaskNo() + "&productCode=" + orderEntity.getProductCode();
        String signReq = EMayEncryptionUntil.md5((String)(sign + this.token));
        String reqStr = "appId=" + this.appId + "&mobile=" + orderEntity.getMobile() + "&clientTaskNo=" + orderEntity.getClientTaskNo() + "&productCode=" + orderEntity.getProductCode() + "&sign=" + signReq;
        HttpClient client = new HttpClient(20, 20, true);
        HttpRequestBody body = null;
        try {
            body = new HttpRequestBody(this.url, "UTF-8", reqStr, HttpClient.HttpMethod.POST, null, null);
        }
        catch (HttpErrorException e) {
            log.error("\u5c01\u88c5\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        HttpResponseBody res = this.activeEnv.contains(UAT) ? client.serviceProxy(body, this.proxyHost, Integer.valueOf(this.proxyPort).intValue()) : client.service(body);
        log.info("\u54cd\u5e94\u6570\u636e : {}", (Object)JSON.toJSONString((Object)res));
        String rs = null;
        if (res.isSuccess()) {
            rs = res.getResultString();
            log.info("getResultString : {}", (Object)rs);
        }
        OrderResp orderResp = (OrderResp)JSON.parseObject((String)rs, OrderResp.class);
        log.info("\u65b9\u6cd5\u8fd4\u56de\u6570\u636e : {}", (Object)JSON.toJSONString((Object)orderResp));
        return orderResp;
    }

    public OrderQueryResp queryEmOrder(OrderQueryEntity orderQueryEntity) {
        log.info("\u8bf7\u6c42 : {}", (Object)JSON.toJSONString((Object)orderQueryEntity));
        String sign = "appId=" + this.appId + "&taskNo=" + orderQueryEntity.getTaskNo() + "&clientTaskNo=" + orderQueryEntity.getClientTaskNo();
        String signReq = EMayEncryptionUntil.md5((String)(sign + this.token));
        String reqStr = "appId=" + this.appId + "&taskNo=" + orderQueryEntity.getTaskNo() + "&clientTaskNo=" + orderQueryEntity.getClientTaskNo() + "&sign=" + signReq;
        HttpClient client = new HttpClient(10, 10, true);
        HttpRequestBody body = null;
        try {
            body = new HttpRequestBody(this.queryOrderUrl, "UTF-8", reqStr, HttpClient.HttpMethod.POST, null, null);
        }
        catch (HttpErrorException e) {
            log.error("HttpErrorException", (Throwable)e);
        }
        HttpResponseBody res = this.activeEnv.contains(UAT) ? client.serviceProxy(body, this.proxyHost, Integer.valueOf(this.proxyPort).intValue()) : client.service(body);
        log.info("\u54cd\u5e94 : {}", (Object)JSON.toJSONString((Object)res));
        if (res.getCode() == -1) {
            return new OrderQueryResp(null, null, "TIME_OUT");
        }
        String rs = null;
        if (res.isSuccess()) {
            rs = res.getResultString();
            log.info("getResultString : {}", (Object)rs);
        }
        OrderQueryResp orderQueryResp = (OrderQueryResp)JSON.parseObject((String)rs, OrderQueryResp.class);
        log.info("\u65b9\u6cd5\u8fd4\u56de\u6570\u636e : {}", (Object)JSON.toJSONString((Object)orderQueryResp));
        return orderQueryResp;
    }

    public EmBalanceQueryResp queryEmOrderBalance() {
        String sign = "appId=" + this.appId + this.token;
        String signReq = EMayEncryptionUntil.md5((String)sign);
        String reqStr = "appId=" + this.appId + "&sign=" + signReq;
        HttpClient client = new HttpClient(10, 10, true);
        HttpRequestBody body = null;
        try {
            body = new HttpRequestBody(this.queryBalanceUrl, "UTF-8", reqStr, HttpClient.HttpMethod.POST, null, null);
        }
        catch (HttpErrorException e) {
            e.printStackTrace();
        }
        HttpResponseBody res = this.activeEnv.contains(UAT) ? client.serviceProxy(body, this.proxyHost, Integer.valueOf(this.proxyPort).intValue()) : client.service(body);
        log.info("\u54cd\u5e94 : {}", (Object)JSON.toJSONString((Object)res));
        String rs = null;
        if (res.isSuccess()) {
            rs = res.getResultString();
            log.info("getResultString : {}", (Object)rs);
        }
        EmBalanceQueryResp emBalanceQueryResp = (EmBalanceQueryResp)JSON.parseObject((String)rs, EmBalanceQueryResp.class);
        log.info("\u65b9\u6cd5\u8fd4\u56de\u6570\u636e : {}", (Object)JSON.toJSONString((Object)emBalanceQueryResp));
        return emBalanceQueryResp;
    }
}

