/*
 * Decompiled with CFR 0.152.
 */
package recharge.center.service.config.yimei;

import java.util.Map;
import recharge.center.service.config.yimei.HttpClient;
import recharge.center.service.config.yimei.HttpErrorException;

public class HttpRequestBody {
    private boolean isHttps = false;
    private String charSet = "UTF-8";
    private HttpClient.HttpMethod method = HttpClient.HttpMethod.GET;
    private String url;
    private Map<String, String> headers;
    private String cookies;
    private String queryString;

    public HttpRequestBody(String url, String charSet, HttpClient.HttpMethod method, Map<String, String> headers, String cookies, Map<String, String> params) throws HttpErrorException {
        this(url, charSet, method, headers, cookies, params, null);
    }

    public HttpRequestBody(String url, String charSet, String paramsString, HttpClient.HttpMethod method, Map<String, String> headers, String cookies) throws HttpErrorException {
        this(url, charSet, method, headers, cookies, null, paramsString);
        if (this.isEmpty((Object)url)) {
            throw new HttpErrorException("url is null");
        }
        if (!this.isEmpty((Object)charSet)) {
            this.charSet = charSet;
        }
        if (method != null) {
            this.method = method;
        }
        this.headers = headers;
        this.cookies = cookies;
        this.queryString = paramsString;
        this.url = url + "?" + this.queryString;
        if (this.url.startsWith("https")) {
            this.isHttps = true;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public HttpClient.HttpMethod getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getCookies() {
        return this.cookies;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getQueryString() {
        return this.queryString;
    }

    private HttpRequestBody(String url, String charSet, HttpClient.HttpMethod method, Map<String, String> headers, String cookies, Map<String, String> params, String paramsString) throws HttpErrorException {
        if (this.isEmpty((Object)url)) {
            throw new HttpErrorException("url is null");
        }
        if (!this.isEmpty((Object)charSet)) {
            this.charSet = charSet;
        }
        if (method != null) {
            this.method = method;
        }
        this.headers = headers;
        this.cookies = cookies;
        this.queryString = this.generateParamsString(params, paramsString);
        this.url = this.generateUrl(url, params, paramsString);
        if (this.url.startsWith("https")) {
            this.isHttps = true;
        }
    }

    private boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return "".equals(((String)obj).trim());
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() == 0;
        }
        return true;
    }

    private String generateParamsString(Map<String, String> params, String paramsString) {
        if (this.method.equals((Object)HttpClient.HttpMethod.GET)) {
            return null;
        }
        if (this.isEmpty((Object)paramsString) && this.isEmpty(params)) {
            return null;
        }
        return this.buildQueryString(params, paramsString);
    }

    private String generateUrl(String requestUrl, Map<String, String> params, String paramsString) {
        if (!requestUrl.startsWith("http")) {
            requestUrl = "http://" + requestUrl;
        }
        if (this.method.equals((Object)HttpClient.HttpMethod.POST) || this.isEmpty((Object)this.queryString)) {
            return requestUrl;
        }
        String qstring = this.buildQueryString(params, paramsString);
        requestUrl = requestUrl.contains("?") ? requestUrl + "&" + qstring : requestUrl + "?" + qstring;
        return requestUrl;
    }

    private String buildQueryString(Map<String, String> params, String paramsString) {
        String queryString = "";
        if (!this.isEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                queryString = queryString + "&" + entry.getKey() + "=" + entry.getValue();
            }
            if (queryString.length() > 0) {
                queryString = queryString.substring(1);
            }
        } else {
            queryString = paramsString;
        }
        if (this.isEmpty((Object)queryString)) {
            return null;
        }
        return queryString;
    }
}

