package spider.api;

import spider.dto.SpiderLogsDto;
import utils.rpc.motan.ApiResponseVo;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 第三方销售价格获取爬虫API
 * @author Liang Wenxu
 * @since 2017-07-04
 * Created by Liang Wenxu on 2017-07-04.
 */
public interface PriceSpiderApi {

    /**
     * 获取当前销售价格
     * @param sku 京东商品id
     * @param storeKey 店铺代码
     * @return 成功时返回data为京东商品销售价格，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>
     *      </pre>
     *      <br>返回的data为BigDecimal，获取到的销售价格
     */
    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku, String storeKey) throws IOException;

    /**
     * 获取当前销售价格（批量）
     * @param storeKey 店铺代码
     * @param skus 京东商品id列表
     * @param triggerType
     * @return 成功时返回data为京东商品销售价格，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>
     *      </pre>
     *      <br>返回的data为key-value分别为sku-price的Map，data内容示意：
     *      {
     *          "sku": price,
     *          "11111": 1700.00,
     *          "2222": 1800.00,
     *          ...
     *      }
     */
    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(String storeKey, List<String> skus, String triggerType) throws IOException;


    /**
     * 获取当前销售价格
     * @param storeKey 店铺代码
     * @param sku 京东商品id
     * @param areaCodeMap 第三方地址代码集合，key为层级，值为地区代码（第三方商户的地区代码）
     * @param triggerType
     * @return 成功时返回data为京东商品销售价格，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>
     *      </pre>
     *      <br>返回的data为SpiderLogs，获取到的销售价格生成的log
     */
    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String storeKey, String sku, Map<Integer, String> areaCodeMap, String triggerType) throws IOException;

    /**
     * 获取当前销售价格（批量）
     * @param storeKey 店铺代码
     * @param skus 京东商品id列表
     * @param areaCodeMap 第三方地址代码集合，key为层级，值为地区代码（第三方商户的地区代码）
     * @param triggerType
     * @return 成功时返回data为京东商品销售价格，失败时返回错误代码errorCode及错误信息message
     *      <br>错误代码errorCode定义：
     *      <pre>
     *      </pre>
     *      <br>返回的data为key-value分别为sku-price的Map，data内容示意：
     *      {
     *          "sku": price,
     *          "11111": 1700.00,
     *          "2222": 1800.00,
     *          ...
     *      }
     */
    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(String storeKey, List<String> skus, Map<Integer, String> areaCodeMap, String triggerType) throws IOException;
}
