package spider.api;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import spider.dto.SpiderLogsDto;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 第三方商户爬虫日志相关API
 * @author Liang Wenxu
 * @since 2017-07-04
 * Created by Liang Wenxu on 2017-07-04.
 */
public interface SpiderLogsApi {
    /**
     * 查询第三方价格爬虫数据日志
     * @param storeId 商户ID
     * @param productCode 产品代码，对应ProductFashion的productCode、goods的sku
     * @param createTimeStart 数据获取日期区间开始
     * @param createTimeEnd 数据获取日期区间结束
     * @return 全部结果集
     */
    public List<SpiderLogsDto> querySpiderLogs(String storeId, String productCode, Date createTimeStart, Date createTimeEnd);

    /**
     * 查询第三方价格爬虫数据日志(分页)
     * @param storeId 商户ID
     * @param productCode 产品代码，对应ProductFashion的productCode、goods的sku
     * @param createTimeStart 数据获取日期区间开始
     * @param createTimeEnd 数据获取日期区间结束
     * @param pageable 分页对象
     * @return 分页结果集
     */
    public Page<SpiderLogsDto> querySpiderLogs(String storeId, String productCode, Date createTimeStart, Date createTimeEnd, Pageable pageable);

    /**
     * 保存一条价格爬虫日志
     * @param storeId 商户ID
     * @param productCode 商品代码
     * @param price 当前价格
     * @param triggerType 触发类型
     * @param content 可选，可记录获取的接口返回
     * @return 已保存的记录
     */
    public SpiderLogsDto logPriceSpider(String storeId, String productCode, BigDecimal price, String triggerType, String content);
}
