package spider.model;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import utils.sql.BaseDomain;

import javax.persistence.*;
import java.math.BigDecimal;

/**
 * 爬虫日志表
 * @author Liang Wenxu
 * @since 2017-07-04
 * Created by Liang Wenxu on 2017-07-04.
 */
@Table(name = "OUT_SPIDER_LOGS")
@Entity
public class SpiderLogs extends BaseDomain {
    /**
     * 爬虫触发节点类型：{@value} 手动触发
     */
    public static final String TRIGGER_TYPE_MANUAL = "MANUAL";
    /**
     * 爬虫触发节点类型：{@value} 订单触发
     */
    public static final String TRIGGER_TYPE_ORDER = "ORDER";
    /**
     * 爬虫触发节点类型：{@value} 商品详情触发
     */
    public static final String TRIGGER_TYPE_PD = "PD";

    /** Attributes ============== */
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    protected String id;

    /**
     * 商户ID
     */
    @Column(length = 36, name = "store_id")
    private String storeId;

    /**
     * 产品代码
     */
    private String productCode;

    /**
     * 当前售价
     */
    @Column(scale = 2)
    private BigDecimal salesPrice;

    /**
     * 爬虫触发节点，取值采用以"TRIGGER_TYPE_"开头的常量
     */
    private String triggerType;

    /**
     * 订单触发时有值，保存触发爬虫时的订单号
     */
    private String orderNo;

    /**
     * 抓取的详细数据内容，JSON格式字符串
     */
    @Column(name = "post_desc", columnDefinition = "clob")
    @Type(type = "text")
    private String content;

    /** Methods ============== */

    /** Dependent Components ============== */

    /** Setter and getters ============== */

    /** 获取 id ============== */
    public String getId() {
        return this.id;
    }

    /** 设置 id ============== */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 商户ID
     */
    public String getStoreId() {
        return this.storeId;
    }

    /**
     * 设置 商户ID
     */
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    /**
     * 获取 产品代码
     */
    public String getProductCode() {
        return this.productCode;
    }

    /**
     * 设置 产品代码
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    /**
     * 获取 当前售价
     */
    public BigDecimal getSalesPrice() {
        return this.salesPrice;
    }

    /**
     * 设置 当前售价
     */
    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    /**
     * 获取 抓取的详细数据内容，JSON格式字符串
     */
    public String getContent() {
        return this.content;
    }

    /**
     * 设置 抓取的详细数据内容，JSON格式字符串
     */
    public void setContent(String content) {
        this.content = content;
    }


    /**
     * 获取 爬虫触发节点，取值采用以"TRIGGER_TYPE_"开头的常量
     */
    public String getTriggerType() {
        return this.triggerType;
    }

    /**
     * 设置 爬虫触发节点，取值采用以"TRIGGER_TYPE_"开头的常量
     */
    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }


    /**
     * 获取 订单触发时有值，保存触发爬虫时的订单号
     */
    public String getOrderNo() {
        return this.orderNo;
    }

    /**
     * 设置 订单触发时有值，保存触发爬虫时的订单号
     */
    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}
