package spider.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import spider.api.PriceSpiderApi;
import spider.dto.SpiderLogsDto;
import spider.service.factory.PriceSpiderHandlerFactory;
import spider.service.handler.PriceSpiderHandler;
import spider.service.utils.SpiderFactoryUtil;
import utils.GlobalContants;
import utils.rpc.motan.ApiResponseVo;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author Liang Wenxu
 * @since 2017-07-21
 * Created by Liang Wenxu on 2017-07-21.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class PriceSpiderApiImpl implements PriceSpiderApi {
    /** Attributes ============== */
    @Autowired
    MapperFacade mapperFacade;

    /** Methods ============== */
    @Override
    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku, String storeKey) throws IOException {
        PriceSpiderHandler handler = getPriceSpiderHandler(storeKey);
        if(handler != null) {
            ApiResponseVo<SpiderLogsDto> spiderResponseVo = handler.getSalesPrice(sku);
            return spiderResponseVo;
        }
        return null;
    }

    @Override
    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(String storeKey, List<String> skus, String triggerType) throws IOException {
        return getBatchSalesPrice(storeKey, skus, null, triggerType);
    }

    @Override
    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String storeKey, String sku, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        PriceSpiderHandler handler = getPriceSpiderHandler(storeKey);
        if(handler != null) {
            ApiResponseVo<SpiderLogsDto> spiderResponseVo = handler.getSalesPrice(sku);
            return spiderResponseVo;
        } else {
            return ApiResponseVo.createErrorResp("HANDLER_NOT_FOUND", "1", null);
        }
    }

    @Override
    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(String storeKey, List<String> skus, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        PriceSpiderHandler handler = getPriceSpiderHandler(storeKey);
        if(handler != null) {
            return handler.getBatchSalesPrice(skus, areaCodeMap, triggerType);
        }
        ApiResponseVo<Map<String, SpiderLogsDto>> responseVo = new ApiResponseVo<>();
        responseVo.setStatus(GlobalContants.ResponseStatus.ERROR);
        responseVo.setCode("1");
        responseVo.setMessage("HANDLER_NOT_FOUND");
        responseVo.setData(null);
        return responseVo;
    }

    private PriceSpiderHandler getPriceSpiderHandler(String storeKey) {
        PriceSpiderHandlerFactory factory = spiderFactoryUtil.getFactory();
        if(factory == null) {
            throw new RuntimeException("PRICE_SPIDER_HANDLER_FACTORY_NOT_FOUND");
        }
        PriceSpiderHandler handler = factory.getPriceSpiderHandlerByStore(storeKey);
        return handler;
    }
/*
    public ApiResponseVo<SpiderLogsDto> setDtoResponseVo(ApiResponseVo<SpiderLogs> spiderResponseVo){
        ApiResponseVo<SpiderLogsDto> spiderDtoResponseVo = new ApiResponseVo<>();
        spiderDtoResponseVo.setCode(spiderResponseVo.getCode());
        spiderDtoResponseVo.setStatus(spiderResponseVo.getStatus());
        spiderDtoResponseVo.setMessage(spiderResponseVo.getMessage());
        spiderDtoResponseVo.setData(Lang.isEmpty(spiderResponseVo.getData())?null:mapperFacade.map(spiderResponseVo.getData(),SpiderLogsDto.class));
        return spiderDtoResponseVo;
    }*/

    /** Dependent Components ============== */

    @Autowired
    SpiderFactoryUtil spiderFactoryUtil;

    /** Setter and getters ============== */
}
