package spider.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import spider.dto.SpiderLogsDto;
import spider.model.SpiderLogs;
import spider.service.service.SpiderLogsService;
import utils.jpa.JpaPageUtil;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2017-07-04
 * Created by Liang Wenxu on 2017-07-04.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SpiderLogsApiImpl implements spider.api.SpiderLogsApi {
    /** Attributes ============== */
    @Autowired
    MapperFacade mapperFacade;
    /** Methods ============== */

    /**
     * @param storeId 商户ID
     * @param productCode 产品代码，对应ProductFashion的productCode、goods的sku
     * @param createTimeStart 数据获取日期区间开始
     * @param createTimeEnd 数据获取日期区间结束
     * @return
     */
    @Override
    public List<SpiderLogsDto> querySpiderLogs(String storeId, String productCode, Date createTimeStart, Date createTimeEnd) {
        Page<SpiderLogs> res = spiderLogsService.findSpiderLogs(storeId, productCode, createTimeStart, createTimeEnd, null);
        return res == null ? null : mapperFacade.mapAsList(res.getContent(),SpiderLogsDto.class);
    }

    /**
     * @param storeId 商户ID
     * @param productCode 产品代码，对应ProductFashion的productCode、goods的sku
     * @param createTimeStart 数据获取日期区间开始
     * @param createTimeEnd 数据获取日期区间结束
     * @param pageable 分页对象
     * @return
     */
    @Override
    public Page<SpiderLogsDto> querySpiderLogs(String storeId, String productCode, Date createTimeStart, Date createTimeEnd, Pageable pageable) {
        Page<SpiderLogs> spiderLogs = spiderLogsService.findSpiderLogs(storeId, productCode, createTimeStart, createTimeEnd, pageable);
        return JpaPageUtil.convertPage(spiderLogs,SpiderLogs.class,SpiderLogsDto.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SpiderLogsDto logPriceSpider(String storeId, String productCode, BigDecimal price, String triggerType, String content) {
        SpiderLogs log = new SpiderLogs();

        return null;
    }

    /** Dependent Components ============== */
    @Autowired
    SpiderLogsService spiderLogsService;
    /** Setter and getters ============== */
}
