package spider.service.factory;

import org.springframework.context.ApplicationContextAware;
import spider.service.handler.PriceSpiderHandler;
import store.api.StoreApi;

/**
 * 价格爬虫处理类获取工厂
 * @author Liang Wenxu
 * @since 2017-07-21
 * Created by Liang Wenxu on 2017-07-21.
 */
public interface PriceSpiderHandlerFactory extends ApplicationContextAware {
    /**
     * 根据店铺获取处理实现类
     * @param storeKey 传storeId或storeCode，优先使用storeCode查找
     * @return
     */
    public PriceSpiderHandler getPriceSpiderHandlerByStore(String storeKey);

    public void setStoreApi(StoreApi storeApi);
}
