package spider.service.factory.impl;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import spider.service.factory.PriceSpiderHandlerFactory;
import spider.service.handler.PriceSpiderHandler;
import spider.service.handler.proxy.PriceSpiderHandlerProxy;
import spider.service.utils.SpiderFactoryUtil;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;


/**
 * 使用SystemConfig配置表获取价格爬虫处理类工厂实现
 * @author Liang Wenxu
 * @since 2017-07-21
 * Created by Liang Wenxu on 2017-07-21.
 */
public class SpringBeanPriceSpiderHandlerFactory implements PriceSpiderHandlerFactory {
    Log logger = Logs.getLog(SpringBeanPriceSpiderHandlerFactory.class.getName());

    private StoreApi storeApi;

    private SpiderFactoryUtil spiderFactoryUtil;

    private static Map<String, PriceSpiderHandler> handlerCache;
    private ApplicationContext applicationContext;

    static {
        handlerCache = new HashMap<>();
    }


    @Override
    public PriceSpiderHandler getPriceSpiderHandlerByStore(String storeKey) {
        String configKey = "spider.handler.bean." + storeKey;
        String beanName = getSpiderFactoryUtil().readProp(configKey);
        logger.info("read config: ["+configKey+": "+beanName+"]");

        if(Lang.isEmpty(beanName)) {
            StoreDto store = storeApi.getStoreInfo(storeKey);
            if(store != null) {
                configKey = "spider.handler.bean." + store.getStoreExt().getCode();
                beanName = getSpiderFactoryUtil().readProp(configKey);
            }
        }

        if(!Lang.isEmpty(beanName)) {
            PriceSpiderHandler handlerBean = (PriceSpiderHandler) applicationContext.getBean(beanName);

            if(handlerBean != null) {
                InvocationHandler proxy = new PriceSpiderHandlerProxy(applicationContext.getBean(beanName));

                PriceSpiderHandler outsideApiHandler = (PriceSpiderHandler) Proxy.newProxyInstance(
                        proxy.getClass().getClassLoader(), handlerBean.getClass().getInterfaces(), proxy);

                return outsideApiHandler;
            }
        }


        return null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setStoreApi(StoreApi storeApi) {
        this.storeApi = storeApi;
    }

    private SpiderFactoryUtil getSpiderFactoryUtil() {
        if(spiderFactoryUtil == null) {
            spiderFactoryUtil = (SpiderFactoryUtil) applicationContext.getBean("spiderFactoryUtil");
        }

        return spiderFactoryUtil;
    }
}
