package spider.service.handler.proxy;

import org.apache.log4j.Logger;
import utils.rpc.motan.ApiResponseVo;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 第三方销售价格获取爬虫API
 * @author Liang Wenxu
 * @since 2017-07-04
 * Created by Liang Wenxu on 2017-07-04.
 */
public class PriceSpiderHandlerProxy implements InvocationHandler{
    Logger log  = Logger.getLogger(PriceSpiderHandlerProxy.class);

    //　代理对象
    private Object subject;

    public PriceSpiderHandlerProxy(Object subject) {
        this.subject = subject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.info("before invoke handler method: " + subject.getClass().getName() + "->" + method.getName());
        Object invokeRes = method.invoke(subject, args);
        log.info("after invoked handler method: " + subject.getClass().getName() + "->" + method.getName());
        return invokeRes;
    }
}
