/*
 * Decompiled with CFR 0.152.
 */
package spider.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import spider.api.PriceSpiderApi;
import spider.dto.SpiderLogsDto;
import spider.service.factory.PriceSpiderHandlerFactory;
import spider.service.handler.PriceSpiderHandler;
import spider.service.utils.SpiderFactoryUtil;
import utils.rpc.motan.ApiResponseVo;

@MotanService(basicService="motanServerBasicConfig")
public class PriceSpiderApiImpl
implements PriceSpiderApi {
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    SpiderFactoryUtil spiderFactoryUtil;

    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku, String storeKey) throws IOException {
        PriceSpiderHandler handler = this.getPriceSpiderHandler(storeKey);
        if (handler != null) {
            ApiResponseVo spiderResponseVo = handler.getSalesPrice(sku);
            return spiderResponseVo;
        }
        return null;
    }

    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(String storeKey, List<String> skus, String triggerType) throws IOException {
        return this.getBatchSalesPrice(storeKey, skus, null, triggerType);
    }

    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String storeKey, String sku, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        PriceSpiderHandler handler = this.getPriceSpiderHandler(storeKey);
        if (handler != null) {
            ApiResponseVo spiderResponseVo = handler.getSalesPrice(sku);
            return spiderResponseVo;
        }
        return ApiResponseVo.createErrorResp((String)"HANDLER_NOT_FOUND", (String)"1", null);
    }

    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(String storeKey, List<String> skus, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        PriceSpiderHandler handler = this.getPriceSpiderHandler(storeKey);
        if (handler != null) {
            return handler.getBatchSalesPrice(skus, areaCodeMap, triggerType);
        }
        ApiResponseVo responseVo = new ApiResponseVo();
        responseVo.setStatus("error");
        responseVo.setCode("1");
        responseVo.setMessage("HANDLER_NOT_FOUND");
        responseVo.setData(null);
        return responseVo;
    }

    private PriceSpiderHandler getPriceSpiderHandler(String storeKey) {
        PriceSpiderHandlerFactory factory = this.spiderFactoryUtil.getFactory();
        if (factory == null) {
            throw new RuntimeException("PRICE_SPIDER_HANDLER_FACTORY_NOT_FOUND");
        }
        PriceSpiderHandler handler = factory.getPriceSpiderHandlerByStore(storeKey);
        return handler;
    }
}

