/*
 * Decompiled with CFR 0.152.
 */
package spider.service.factory.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import spider.service.factory.PriceSpiderHandlerFactory;
import spider.service.handler.PriceSpiderHandler;
import spider.service.handler.proxy.PriceSpiderHandlerProxy;
import spider.service.utils.SpiderFactoryUtil;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

public class SpringBeanPriceSpiderHandlerFactory
implements PriceSpiderHandlerFactory {
    Log logger = Logs.getLog((String)SpringBeanPriceSpiderHandlerFactory.class.getName());
    private StoreApi storeApi;
    private SpiderFactoryUtil spiderFactoryUtil;
    private static Map<String, PriceSpiderHandler> handlerCache = new HashMap();
    private ApplicationContext applicationContext;

    public PriceSpiderHandler getPriceSpiderHandlerByStore(String storeKey) {
        PriceSpiderHandler handlerBean;
        StoreDto store;
        String configKey = "spider.handler.bean." + storeKey;
        String beanName = this.getSpiderFactoryUtil().readProp(configKey);
        this.logger.info((Object)("read config: [" + configKey + ": " + beanName + "]"));
        if (Lang.isEmpty((Object)beanName) && (store = this.storeApi.getStoreInfo(storeKey)) != null) {
            configKey = "spider.handler.bean." + store.getStoreExt().getCode();
            beanName = this.getSpiderFactoryUtil().readProp(configKey);
        }
        if (!Lang.isEmpty((Object)beanName) && (handlerBean = (PriceSpiderHandler)this.applicationContext.getBean(beanName)) != null) {
            PriceSpiderHandlerProxy proxy = new PriceSpiderHandlerProxy(this.applicationContext.getBean(beanName));
            PriceSpiderHandler outsideApiHandler = (PriceSpiderHandler)Proxy.newProxyInstance(proxy.getClass().getClassLoader(), handlerBean.getClass().getInterfaces(), (InvocationHandler)proxy);
            return outsideApiHandler;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setStoreApi(StoreApi storeApi) {
        this.storeApi = storeApi;
    }

    private SpiderFactoryUtil getSpiderFactoryUtil() {
        if (this.spiderFactoryUtil == null) {
            this.spiderFactoryUtil = (SpiderFactoryUtil)this.applicationContext.getBean("spiderFactoryUtil");
        }
        return this.spiderFactoryUtil;
    }
}

