/*
 * Decompiled with CFR 0.152.
 */
package spider.service.handler.impl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import spider.dto.SpiderLogsDto;
import spider.model.SpiderLogs;
import spider.service.handler.PriceSpiderHandler;
import spider.service.service.SpiderLogsService;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.rpc.motan.ApiResponseVo;

@Component
public class JdPriceSpiderHandlerImpl
implements PriceSpiderHandler {
    Log logs = Logs.getLog((String)JdPriceSpiderHandlerImpl.class.getName());
    private static StoreDto store;
    @Value(value="${spider.httpclient.request.connectTimeout:3000}")
    private Integer connectTimeout;
    @Value(value="${spider.httpclient.request.connectionRequestTimeout:3000}")
    private Integer connectionRequestTimeout;
    @Value(value="${spider.httpclient.request.socketTimeout:5000}")
    private Integer socketTimeout;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @Autowired
    SpiderLogsService spiderLogsService;
    @MotanReferer
    StoreApi storeApi;

    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku) throws IOException {
        return this.getSalesPrice(sku, null, "MANUAL");
    }

    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(List<String> skus) throws IOException {
        return this.getBatchSalesPrice(skus, null, "MANUAL");
    }

    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        ArrayList<String> skus = new ArrayList<String>();
        skus.add(sku);
        ApiResponseVo batchRes = this.getBatchSalesPrice(skus, areaCodeMap, triggerType);
        if (batchRes.getStatus().equals("success")) {
            return ApiResponseVo.createSucResp(((Map)batchRes.getData()).get(sku), (String)"suc", (String)"0");
        }
        return ApiResponseVo.createErrorResp((String)batchRes.getMessage(), (String)batchRes.getCode(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(List<String> skus, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        ApiResponseVo responseVo = null;
        String priceUrl = this.systemConfigApi.getConfigValue("COMMON", "JD_SPIDERCONFIGS", "JD_PRICE_URL", Boolean.valueOf(true), Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)priceUrl)) {
            Long time;
            block19: {
                StringBuilder skuIdSb = new StringBuilder();
                for (String sku : skus) {
                    skuIdSb.append(",").append("J_").append(sku);
                }
                priceUrl = priceUrl.replace("{sku}", skuIdSb.substring(1));
                StringBuilder addressStr = new StringBuilder();
                if (areaCodeMap != null) {
                    for (int lv = 1; lv <= 4; ++lv) {
                        if (areaCodeMap.get(lv) != null) {
                            addressStr.append(areaCodeMap.get(lv));
                        } else {
                            addressStr.append("0");
                        }
                        if (lv == 4) continue;
                        addressStr.append("_");
                    }
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout.intValue()).setConnectionRequestTimeout(this.connectionRequestTimeout.intValue()).setSocketTimeout(this.socketTimeout.intValue()).build();
                priceUrl = priceUrl.replace("{area}", addressStr.toString());
                CloseableHttpClient httpclient = HttpClients.createDefault();
                HttpGet httpGet = new HttpGet(priceUrl);
                httpGet.setConfig(requestConfig);
                CloseableHttpResponse response = null;
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                time = System.currentTimeMillis();
                try {
                    response = httpclient.execute((HttpUriRequest)httpGet);
                    System.out.println(response.getStatusLine());
                    if (response.getStatusLine().getStatusCode() != 200) break block19;
                    HttpEntity entity = response.getEntity();
                    String contentJson = EntityUtils.toString((HttpEntity)entity);
                    System.out.println("JD Spider HTTP Response: " + contentJson);
                    boolean sucFlag = false;
                    try {
                        List jsonArray = JSON.parseArray((String)contentJson, Map.class);
                        for (Map m : jsonArray) {
                            SpiderLogs spLog = new SpiderLogs();
                            spLog.setTriggerType(Lang.isEmpty((Object)triggerType) ? "MANUAL" : triggerType);
                            spLog.setProductCode(((String)m.get("id")).toUpperCase().replace("J_", ""));
                            spLog.setSalesPrice(Lang.isEmpty(m.get("p")) ? BigDecimal.ZERO : new BigDecimal(m.get("p").toString()));
                            spLog.setStoreId(this.getStore().getId());
                            spLog.setContent(contentJson);
                            this.spiderLogsService.saveLog(spLog);
                            returnData.put(spLog.getProductCode(), this.mapperFacade.map((Object)spLog, SpiderLogsDto.class));
                        }
                        sucFlag = true;
                        responseVo = ApiResponseVo.createSucResp(returnData, (String)"suc", (String)"0");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        sucFlag = false;
                    }
                    if (!sucFlag) {
                        responseVo = ApiResponseVo.createErrorResp((String)"\u6293\u53d6\u4eac\u4e1c\u6570\u636e\u5931\u8d25\uff0c\u8be5sku\u65e0\u6cd5\u6293\u53d6\u5230\u4eac\u4e1c\u6570\u636e", (String)"2", (Object)("" + contentJson));
                    }
                }
                catch (ClientProtocolException e) {
                    e.printStackTrace();
                    responseVo = ApiResponseVo.createErrorResp((String)("\u6293\u53d6\u4eac\u4e1c\u6570\u636e\u5931\u8d25\uff1a" + e.getLocalizedMessage()), (String)"3", (Object)Lang.toString((Object)((Object)e)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    responseVo = ApiResponseVo.createErrorResp((String)("\u6293\u53d6\u4eac\u4e1c\u6570\u636e\u5931\u8d25\uff1a" + e.getLocalizedMessage()), (String)"3", (Object)Lang.toString((Object)e));
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            this.logs.info((Object)"\u9500\u552e\u4ef7\u683c\u63a5\u53e3\uff08\u4eac\u4e1c\uff09\u65f6\u957f\uff1a{}ms", new Object[]{System.currentTimeMillis() - time});
        } else {
            responseVo = ApiResponseVo.createErrorResp((String)"JD_PRICE_URL\u672a\u914d\u7f6e", (String)"1", null);
        }
        return responseVo;
    }

    private StoreDto getStore() {
        if (store == null) {
            store = this.storeApi.findByCode("jd");
        }
        return store;
    }
}

