/*
 * Decompiled with CFR 0.152.
 */
package spider.service.handler.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ma.glasnost.orika.MapperFacade;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import spider.dto.SpiderLogsDto;
import spider.model.SpiderLogs;
import spider.service.handler.PriceSpiderHandler;
import spider.service.service.SpiderLogsService;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import sysmg.api.SystemLogApi;
import sysmg.dto.SystemLogDto;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.rpc.motan.ApiResponseVo;

@Component
public class SnPriceSpiderHandlerImpl
implements PriceSpiderHandler {
    Log logger = Logs.getLog((String)SnPriceSpiderHandlerImpl.class.getName());
    private static StoreDto store;
    @Value(value="${spider.httpclient.request.connectTimeout:3000}")
    private Integer connectTimeout;
    @Value(value="${spider.httpclient.request.connectionRequestTimeout:3000}")
    private Integer connectionRequestTimeout;
    @Value(value="${spider.httpclient.request.socketTimeout:5000}")
    private Integer socketTimeout;
    @Autowired
    MapperFacade mapperFacade;
    @MotanReferer
    SystemConfigApi systemConfigApi;
    @Autowired
    SpiderLogsService spiderLogsService;
    @MotanReferer
    StoreApi storeApi;
    @MotanReferer
    SystemLogApi systemLogApi;

    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku) throws IOException {
        return this.getSalesPrice(sku, null, "MANUAL");
    }

    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(List<String> skus) throws IOException {
        return this.getBatchSalesPrice(skus, null, "MANUAL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        ApiResponseVo responseVo = new ApiResponseVo();
        String pdUrl = this.systemConfigApi.getConfigValue("COMMON", "SN_SPIDERCONFIGS", "SN_PD_URL", Boolean.valueOf(true), Boolean.valueOf(true));
        String areaUrl = this.systemConfigApi.getConfigValue("COMMON", "SN_SPIDERCONFIGS", "SN_AREA_SELECT_URL", Boolean.valueOf(true), Boolean.valueOf(true));
        String priceUrl = this.systemConfigApi.getConfigValue("COMMON", "SN_SPIDERCONFIGS", "SN_PRICE_URL", Boolean.valueOf(true), Boolean.valueOf(true));
        pdUrl = !Lang.isEmpty((Object)pdUrl) ? pdUrl.replaceAll("\\{sku\\}", sku) : "";
        this.logger.info((Object)("get suning PD page url: ----->\r\n" + pdUrl));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout.intValue()).setConnectionRequestTimeout(this.connectionRequestTimeout.intValue()).setSocketTimeout(this.socketTimeout.intValue()).build();
        HttpGet httpGet = new HttpGet(pdUrl);
        httpGet.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        HashMap returnData = new HashMap();
        Boolean spiderError = false;
        String spiderErrorMsg = "";
        String spiderErrorContent = "";
        String spiderRequestUrl = "";
        StringBuilder snPriceUrlSb = new StringBuilder();
        try {
            response = httpclient.execute((HttpUriRequest)httpGet);
            System.out.println(response.getStatusLine());
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String html = EntityUtils.toString((HttpEntity)entity);
                this.logger.info((Object)("get suning PD page: ----->\r\n" + html));
                String snConfigStrRegxStr = "var\\s*sn\\s*=\\s*sn\\s*\\|\\|\\s*\\{(.*?)\\}\\s*;";
                Pattern patternSn = Pattern.compile(snConfigStrRegxStr);
                Matcher matcherSn = patternSn.matcher(html);
                String snStr = "";
                while (matcherSn.find()) {
                    if (matcherSn.groupCount() < 1) continue;
                    snStr = matcherSn.group(1);
                }
                snStr = snStr.replaceAll("\"cuxiaoSeq\":\\{.*?\\},", "");
                snStr = snStr.replaceAll("\"itemDomain\":.*?,", "");
                snStr = snStr.replaceAll("/\\*.*?\\*/", "");
                snStr = "{" + snStr + "}";
                Map snMap = (Map)JSON.parseObject((String)snStr, HashMap.class);
                if (areaCodeMap == null) {
                    areaCodeMap = new HashMap<Integer, String>();
                    areaCodeMap.put(1, "20");
                    areaCodeMap.put(2, "021");
                    areaCodeMap.put(3, "13");
                }
                snMap.put("provinceCode", areaCodeMap.get(1));
                snMap.put("lesCityId", areaCodeMap.get(2));
                snMap.put("lesDistrictId", areaCodeMap.get(3));
                snMap.put("lesCodeStr", areaCodeMap.get(1) + areaCodeMap.get(2) + "01");
                if (!priceUrl.startsWith("http")) {
                    priceUrl = "https:" + (priceUrl.startsWith("//") ? "" : "//");
                }
                snPriceUrlSb.append(priceUrl).append("0").append("_").append(snMap.get("passPartNumber") == null ? "" : (String)snMap.get("passPartNumber")).append("_").append(snMap.get("partNumber") == null ? "" : (String)snMap.get("partNumber")).append("_").append(snMap.get("vendorCode") == null ? "" : (String)snMap.get("vendorCode")).append("_").append(snMap.get("provinceCode") == null ? "" : (String)snMap.get("provinceCode")).append("_").append(snMap.get("lesCityId") == null ? "" : (String)snMap.get("lesCityId")).append("_").append("_").append(snMap.get("category1") == null ? "" : (String)snMap.get("category1")).append("_").append(snMap.get("mdmCityId") == null ? "" : (String)snMap.get("mdmCityId")).append("_").append(snMap.get("cityId") == null ? "" : (String)snMap.get("cityId")).append("_").append(snMap.get("districtId") == null ? "" : (String)snMap.get("districtId")).append("_").append(snMap.get("cmmdtyType") == null ? "" : (String)snMap.get("cmmdtyType")).append("_").append(snMap.get("custLevel") == null ? "" : (String)snMap.get("custLevel")).append("_").append("").append("_").append(snMap.get("manageInvFlag") == null ? "" : (String)snMap.get("manageInvFlag")).append("_").append(snMap.get("factorySendFlag") == null ? "" : (String)snMap.get("factorySendFlag")).append("_").append(snMap.get("ownerPlace") == null ? "" : (String)snMap.get("ownerPlace")).append("_").append(snMap.get("accountPlace") == null ? "" : (String)snMap.get("accountPlace")).append("_").append(snMap.get("deptNo") == null ? "" : (String)snMap.get("deptNo")).append("_").append(snMap.get("vendor") == null ? "" : (String)snMap.get("vendor")).append("_").append(snMap.get("sendAvalidTime") == null ? "" : (String)snMap.get("sendAvalidTime")).append("_").append(snMap.get("purChaseType") == null ? "" : (String)snMap.get("purChaseType")).append("_").append(snMap.get("bookActionID") == null ? "" : (String)snMap.get("bookActionID")).append("_").append(snMap.get("priceType") == null ? "" : (String)snMap.get("priceType")).append("_").append(snMap.get("vendorType") == null ? "" : (String)snMap.get("vendorType")).append("_").append(snMap.get("juId") == null ? "" : (String)snMap.get("juId")).append("_").append(snMap.get("promotionPrice") == null ? "" : (String)snMap.get("promotionPrice")).append("_").append(snMap.get("bookGoodID") == null ? "" : (String)snMap.get("bookGoodID")).append("_").append(snMap.get("invStatus") == null ? "" : (String)snMap.get("invStatus")).append("_").append(snMap.get("vendor") == null ? "" : (String)snMap.get("vendor")).append(".html");
                this.logger.info((Object)("\u67e5\u8be2\u82cf\u5b81\u4ef7\u683c\u63a5\u53e3URL-> " + snPriceUrlSb.toString()));
                response.close();
                response = null;
                httpGet = new HttpGet(snPriceUrlSb.toString());
                httpGet.setConfig(requestConfig);
                httpclient = HttpClients.createDefault();
                response = httpclient.execute((HttpUriRequest)httpGet);
                System.out.println(response.getStatusLine());
                if (response.getStatusLine().getStatusCode() == 200) {
                    entity = response.getEntity();
                    String snPriceJson = EntityUtils.toString((HttpEntity)entity);
                    if (!Lang.isEmpty((Object)snPriceJson)) {
                        Map jsonData = (Map)JSON.parseObject((String)snPriceJson.substring(snPriceJson.indexOf("pcData(") + "pcData(".length(), snPriceJson.lastIndexOf(")")), HashMap.class);
                        if (!Lang.isEmpty(jsonData.get("code")) && jsonData.get("code").toString().equals("1")) {
                            if (!Lang.isEmpty(jsonData.get("data"))) {
                                Map data = (Map)jsonData.get("data");
                                if (!Lang.isEmpty((Object)data)) {
                                    Map price = (Map)data.get("price");
                                    if (!Lang.isEmpty((Object)price)) {
                                        JSONArray saleInfo = (JSONArray)price.get("saleInfo");
                                        if (saleInfo != null && saleInfo.size() > 0) {
                                            JSONObject si = (JSONObject)saleInfo.get(0);
                                            BigDecimal snPrice = si.getBigDecimal("promotionPrice");
                                            SpiderLogs spiderLogs = new SpiderLogs();
                                            spiderLogs.setStoreId(this.getStore().getId());
                                            spiderLogs.setSalesPrice(snPrice);
                                            spiderLogs.setContent(snPriceJson);
                                            spiderLogs.setProductCode(sku);
                                            spiderLogs.setTriggerType(triggerType);
                                            this.spiderLogsService.saveLog(spiderLogs);
                                            responseVo.setData(this.mapperFacade.map((Object)spiderLogs, SpiderLogsDto.class));
                                            responseVo.setStatus("success");
                                            spiderError = false;
                                        } else {
                                            spiderError = true;
                                            spiderErrorMsg = jsonData.get("message") == null ? "\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6AJAX\u8fd4\u56de\u6570\u636e\u6709\u8bef" : jsonData.get("message").toString();
                                        }
                                    } else {
                                        spiderError = true;
                                        spiderErrorMsg = jsonData.get("message") == null ? "\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6AJAX\u8fd4\u56de\u6570\u636e\u6709\u8bef" : jsonData.get("message").toString();
                                    }
                                } else {
                                    spiderError = true;
                                    spiderErrorMsg = jsonData.get("message") == null ? "\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6AJAX\u8fd4\u56de\u6570\u636e\u6709\u8bef" : jsonData.get("message").toString();
                                }
                            } else {
                                spiderError = true;
                                spiderErrorMsg = jsonData.get("message") == null ? "\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6AJAX\u8fd4\u56de\u6570\u636e\u6709\u8bef" : jsonData.get("message").toString();
                            }
                        } else {
                            spiderError = true;
                            spiderErrorMsg = jsonData.get("message") == null ? "\u82cf\u5b81\u4ef7\u683c\u83b7\u53d6AJAX\u8fd4\u56de\u6570\u636e\u6709\u8bef" : jsonData.get("message").toString();
                        }
                    } else {
                        spiderError = true;
                        spiderErrorMsg = "\u82cf\u5b81\u4ef7\u683cAJAX\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a";
                    }
                    this.logger.info((Object)("get suning price json: ----->\r\n" + snPriceJson));
                    spiderErrorContent = snPriceJson;
                } else {
                    spiderError = true;
                    spiderErrorContent = response.getStatusLine().toString();
                }
                spiderRequestUrl = snPriceUrlSb.toString();
            } else {
                spiderRequestUrl = pdUrl;
            }
            if (spiderError.booleanValue()) {
                this.systemLogApi.saveBean(new SystemLogDto("" + spiderRequestUrl, "SN_PRICE_SPIDER", "ERROR", "" + spiderErrorContent));
                responseVo.setStatus("error");
                responseVo.setMessage(spiderErrorMsg);
            }
        }
        catch (ClientProtocolException e) {
            this.logger.error((Object)"\u6293\u53d6\u82cf\u5b81\u722c\u866b\u6570\u636e\u5931\u8d25\uff01", new Object[]{e});
            responseVo = ApiResponseVo.createErrorResp((String)("\u6293\u53d6\u4eac\u4e1c\u6570\u636e\u5931\u8d25\uff1a" + e.getLocalizedMessage()), (String)"3", (Object)Lang.toString((Object)((Object)e)));
        }
        catch (IOException e) {
            this.logger.error((Object)"\u6293\u53d6\u82cf\u5b81\u722c\u866b\u6570\u636e\u5931\u8d25\uff01", new Object[]{e});
            responseVo = ApiResponseVo.createErrorResp((String)("\u6293\u53d6\u4eac\u4e1c\u6570\u636e\u5931\u8d25\uff1a" + e.getLocalizedMessage()), (String)"3", (Object)Lang.toString((Object)e));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return responseVo;
    }

    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(List<String> skus, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        ApiResponseVo responseVo = new ApiResponseVo();
        HashMap<String, Object> rtnData = new HashMap<String, Object>();
        for (String sku : skus) {
            ApiResponseVo r = this.getSalesPrice(sku, areaCodeMap, triggerType);
            if (!"success".equals(r.getStatus())) continue;
            rtnData.put(sku, r.getData());
        }
        responseVo.setStatus("success");
        responseVo.setData(rtnData);
        return responseVo;
    }

    private StoreDto getStore() {
        if (store == null) {
            store = this.storeApi.findByCode("suning");
        }
        return store;
    }
}

