/*
 * Decompiled with CFR 0.152.
 */
package spider.service.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import spider.model.SpiderLogs;
import spider.model.repository.SpiderLogsRepos;
import spider.service.utils.SpiderFactoryUtil;
import utils.log.Log;
import utils.log.Logs;

@Component
@Transactional(readOnly=true)
public class SpiderLogsService {
    Log log = Logs.getLog((String)"SpiderLogsService");
    @Autowired
    SpiderFactoryUtil spiderFactoryUtil;
    @Autowired
    SpiderLogsRepos spiderLogsRepos;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public Page<SpiderLogs> findSpiderLogs(String storeId, String productCode, Date createTimeStart, Date createTimeEnd, Pageable pageable) {
        return this.spiderLogsRepos.findAll((Specification)new /* Unavailable Anonymous Inner Class!! */, pageable);
    }

    @Transactional(readOnly=false)
    public void saveLog(SpiderLogs log) {
        this.spiderLogsRepos.saveAndFlush((Object)log);
    }

    public void doUpdatePrices(Integer poolSize, Integer pageSize, Integer dbPoolSize, Integer dbPageSize) {
        Date startTime = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.log.info((Object)("doUpdatePrices starts: " + sdf.format(new Date())));
        poolSize = poolSize == null ? 10 : poolSize;
        ExecutorService dbQueryThreadPool = Executors.newFixedThreadPool(dbPoolSize);
        ExecutorService reqThreadPool = Executors.newFixedThreadPool(poolSize);
        Integer totalCount = (Integer)this.jdbcTemplate.queryForObject("SELECT COUNT(0) FROM goods g JOIN store s ON s.ID = g.STORE_ID JOIN STORE_EXT se on se.STORE_ID = s.id WHERE se.CODE='jd'", Integer.class);
        int totalPageNum = (totalCount + dbPageSize - 1) / dbPageSize;
        ArrayList dbFutures = new ArrayList();
        int pageNum = 0;
        while (pageNum < totalPageNum) {
            int finalPageNum = pageNum++;
            dbFutures.add(dbQueryThreadPool.submit(new /* Unavailable Anonymous Inner Class!! */));
        }
        int totalHandled = 0;
        for (Future future : dbFutures) {
            try {
                totalHandled += ((Integer)future.get()).intValue();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.log.info((Object)("\u6240\u6709\u4eac\u4e1c\u5546\u54c1\u4ef7\u683c\u83b7\u53d6\u5b8c\u6bd5\uff0c\u603b\u5904\u7406\u6570\u636e" + totalHandled + "\uff0c\u603b\u8017\u65f6:" + (new Date().getTime() - startTime.getTime()) / 1000L + "s"));
        dbQueryThreadPool.shutdown();
        reqThreadPool.shutdown();
    }
}

