/*
 * Decompiled with CFR 0.152.
 */
package spider.service.utils;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.Hashtable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import spider.service.factory.PriceSpiderHandlerFactory;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;

@Component
public class SpiderFactoryUtil
implements ApplicationContextAware {
    private static final String FACTORY_NAME_CONFIG_KEY = "outside.common.spiderhandler.factor";
    private static Hashtable<String, Class<PriceSpiderHandlerFactory>> factoryClassCache = new Hashtable();
    private static Hashtable<String, PriceSpiderHandlerFactory> factoryCache = new Hashtable();
    private ApplicationContext applicationContext;
    @Autowired
    private Environment env;
    @MotanReferer
    StoreApi storeApi;

    public PriceSpiderHandlerFactory getFactory() {
        return this.getFactory(this.readProp(FACTORY_NAME_CONFIG_KEY));
    }

    public PriceSpiderHandlerFactory getFactory(String factoryName) {
        PriceSpiderHandlerFactory factory = (PriceSpiderHandlerFactory)factoryCache.get(factoryName);
        if (factory == null) {
            Class<?> clz = (Class<?>)factoryClassCache.get(factoryName);
            if (clz == null) {
                try {
                    clz = Class.forName(factoryName);
                    factoryClassCache.put(factoryName, clz);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            try {
                factory = (PriceSpiderHandlerFactory)clz.newInstance();
                factory.setStoreApi(this.storeApi);
                if (factory instanceof ApplicationContextAware) {
                    factory.setApplicationContext(this.applicationContext);
                }
                factoryCache.put(factoryName, factory);
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return factory;
    }

    public String readProp(String key) {
        return this.env.getProperty(key);
    }

    public StoreDto findStoreById(String id) {
        return this.storeApi.getStoreInfo(id);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

