package suning.api;

import com.suning.api.entity.govbus.*;
import pool.dto.ProviderGoodsDto;

import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-04-20.
 * 苏宁公用转换API
 */

public interface SnCommonConvertApi {
    public static final String API_NAME_PRE_DEPOSIT_BALANCE = "preDepositBalanceService";
    public static final String API_NAME_SN_ADDRESS = "snAddressService";
    public static final String API_NAME_SN_INVOICE = "snInvoiceService";
    public static final String API_NAME_SN_MESSAGE = "snMessageService";
    public static final String API_NAME_SN_ORDERSE = "snOrderService";
    public static final String API_NAME_SN_PRICE = "snPriceService";
    public static final String API_NAME_SN_PROD = "snProdService";
    public static final String API_NAME_SN_SHIPPING = "snShippingService";
    public static final String API_NAME_SN_STOCK = "snStockService";

    /**
     * 多商品的库存批量查询接口
     * @param paramList 参数列表
     * @param cityId 城市代码
     * @return 转换后结果集
     */
    List<Map<String,String>> queryGoodsMprodStock(List<Map<String, String>> paramList, String cityId);

    /**
     * 单个商品的精准库存查询接口
     * @param paramList 参数列表
     * @param cityId 城市地区id
     * @param countyId 区县地区id
     * @return 转换后结果集
     */
    List<Map<String,String>> getGoodsInventory(List<Map<String, String>> paramList, String cityId, String countyId);

    /**
     * 单个商品的精准库存查询接口
     * @param paramList 参数列表
     * @return 转换后结果集
     */
    List<Map<String,String>> getBatchProdSaleStatus(List<Map<String, String>> paramList);

    /**
     * 商品售价获取API
     * <p>调用样例</p>
     * <code>
     *     List<FashionPriceParamVo> priceParamVos = requet.getFashionPriceParamVos();
     Map<String,String> addrMap = transToNationAddress(requet.getProvinceCode(),requet.getCityCode(),requet.getCountyCode(),requet.getTownCode());
     if(!Lang.isEmpty(addrMap)) {
     List<Map<String, String>> priceParam = new ArrayList<Map<String, String>>();
     for (FashionPriceParamVo priceParamVo : priceParamVos) {
     Map<String, String> map = new HashMap<String, String>();
     map.put("skuId", priceParamVo.getProductCode());
     fashionIdMap.put(priceParamVo.getProductCode(), priceParamVo.getFactionId());
     priceParam.add(map);
     }
     }
     * </code>
     * @param priceParam 参数列表
     * @param cityId 城市地区id
     * @return 转换后结果集
     */
    List<Map<String,String>> queryGoodsPrice(List<Map<String, String>> priceParam, String cityId);

    /**
     * suning.govbus.order.add 创建订单接口
     * @param requestJson {@link OrderAddRequest} 转成JSON
     * @return {@link OrderAddResponse} 转换成JSON
     */
    public String addOrder(String requestJson);

    /**
     * suning.govbus.confirmorder.add 确认预占库存订单接口
     * @param requestJson {@link ConfirmOrderAddRequest} 转成JSON
     * @return {@link ConfirmOrderAddResponse} 转换成JSON
     */
    public String addConfirmOrder(String requestJson);

    /**
     *
     *suning.govbus.rejectorder.delete 取消预占库存订单接口
     * @param requestJson {@link RejectOrderDeleteRequest} 转换成JSON
     * @return {@link RejectOrderDeleteResponse} 转换成JSON
     */
    public String cancelOrder(String requestJson);

    /**
     * suning.govbus.shiptime.get 物流时效接口
     * @param requestJson {@link ShipTimeGetRequest} 转换成JSON
     * @return {@link ShipTimeGetResponse} 转换成JSON
     */
    public String getShipTime(String requestJson);

    /**
     *  suning.govbus.shipcarriage.get 物流运费接口
     * @param requestJson {@link ShipCarriageGetRequest} 转换成JSON
     * @return {@link ShipCarriageGetResponse} 转换成JSON
     */
    public String getShipCarriage(String requestJson);

    /**
     * 通用的转换Api调用
     *
     * <br> 调用样例：
     * <pre><code>
     *     FacProductConfirmRequest request = new FacProductConfirmRequest();
     *     request.setOrderId(requst.getOrderThirdNo());
     *     String respJson = snCommonConvertApi.commonJsonInvoke(JSON.toJSONString(request),
     *     SnCommonConvertApi.API_NAME_SN_SHIPPING, "confirmFacProduct", request.getClass());
     * </code></pre>
     * @param requestJson 请求参数的JSON串
     * @param requestApiName 请求的API
     * @param requestMethodName 请求的API方法名
     * @param requestType 请求参数vo对象的类型
     * @return 请求API的返回VO转换成json
     */
    public String commonJsonInvoke(String requestJson, String requestApiName, String requestMethodName, Class requestType);


    Map addProdBySkus(Map resMap, String skuids, String categoryId, String categoryName, String cmmdtyType);


    ProviderGoodsDto updateSnGoodsMessageHandel(String sku) ;
}
