package suning.api.good;

import com.suning.api.entity.govbus.*;

/**
 * 苏宁产品相关API
 * Created by Roney on 2017-04-05.
 */
public interface SnProductApi {



    /**
     * suning.govbus.prodpool.query 获取商品池
     * @param request
     * @return
     */
    public ProdPoolQueryResponse queryProdPool(ProdPoolQueryRequest request);


    /**
     * suning.govbus.judgefacproduct.get
     * 判断商品是否厂送接口
     * @param request
     * @return
     */

    public JudgefacproductGetResponse  getJudgefacProduct(JudgefacproductGetRequest request);
    /**
     * suning.govbus.proddetail.get 获取商品详情接口
     * @param request
     * @return
     */
    public ProdDetailGetResponse getProdDetail(ProdDetailGetRequest request);

    /**
     * suning.govbus.prodimage.query 获取商品图片接口
     * @param request
     * @return
     */
    public ProdImageQueryResponse queryProdImage(ProdImageQueryRequest request);

    /**
     * suning.govbus.batchprodsalestatus.get 商品上下架状态查询接口
     * @param request
     * @return
     */
    public BatchProdSaleStatusGetResponse getBatchProdSaleStatus(BatchProdSaleStatusGetRequest request);

    /**
     * suning.govbus.prodreview.query 获取商品评价接口
     * @param request
     * @return
     */
    public ProdReviewQueryResponse queryProdReview(ProdReviewQueryRequest request);


    /***
     * suning.govbus.prodextend.get 查询商品扩展信息接口
     * @param request
     * @return
     */
    public ProdextendGetResponse  getProdextend(ProdextendGetRequest request);
    /**
     * suning.govbus.combinationprod.query 获取套餐清单
     * @param request
     * @return
     */
    //public CombinationProdQueryResponse queryCombinationProd(CombinationProdQueryRequest request);
}
