package suning.api.order;

import com.suning.api.entity.govbus.*;

/**
 * 苏宁订单相关API
 * Created by Roney on 2017-04-05.
 */
public interface SnOrderApi {
    /**
     * suning.govbus.order.add 创建订单接口
     * @param request
     * @return
     */
    public OrderAddResponse addOrder(OrderAddRequest request);

    /**
     * suning.govbus.confirmorder.add 确认预占库存订单接口
     * @param request
     * @return
     */
    public ConfirmOrderAddResponse addConfirmOrder(ConfirmOrderAddRequest request);

    /**
     * suning.govbus.rejectorder.delete 取消预占库存订单接口
     * @param request
     * @return
     */
    public RejectOrderDeleteResponse deleteRejectOrder(RejectOrderDeleteRequest request);

    /**
     * suning.govbus.applyrejected.add 退货接口申请
     * @param request
     * @return
     */
    public ApplyRejectedAddResponse addApplyRejected(ApplyRejectedAddRequest request);

    /**
     * suning.govbus.orderdetail.get 查询单个订单详细
     * @param request
     * @return
     */
    public OrderDetailGetResponse getOrderDetail(OrderDetailGetRequest request);

    /**
     * suning.govbus.orderstatus.get 获取订单状态接口
     * @param request
     * @return
     */
    public OrderStatusGetResponse getOrderStatus(OrderStatusGetRequest request);

    /**
     * suning.govbus.orderaccount.query 订单对账接口
     * @param request
     * @return
     */
    //public OrderAccountQueryResponse queryOrderAccount(OrderAccountQueryRequest request);
}
