package suning.model;

import org.hibernate.annotations.GenericGenerator;
import utils.sql.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by Dy on 2017/04/29.
 *
 * 苏宁与主地址表的关联表
 *
 */
@Entity
@Table
public class SnAddressRelation extends BaseDomain implements Serializable {
    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String id;

    /**
     * 主地址表id
     *  Address.id
     */
    private String addressId;

    /**
     * 苏宁地址表id
     *  SnNationalAddress.snAddressId
     */
    private String suningId;

    public SnAddressRelation() {
    }

    public SnAddressRelation(String addressId, String suningId) {
        this.addressId = addressId;
        this.suningId = suningId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAddressId() {
        return addressId;
    }

    public void setAddressId(String addressId) {
        this.addressId = addressId;
    }

    public String getSuningId() {
        return suningId;
    }

    public void setSuningId(String suningId) {
        this.suningId = suningId;
    }
}
