package suning.model;

import org.hibernate.annotations.GenericGenerator;
import suning.model.base.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by Roney on 2017-04-06.
 */
@Entity
@Table(name = "SN_NATIONAL_ADDRESS",uniqueConstraints = {
        @UniqueConstraint(name = "uk_sn_address_id", columnNames = {"sn_id",  "sn_level"})
},
        indexes = {
                @Index(name = "idx_sn_address_id", columnList = "id"),
                @Index(name = "idx_sn_address_p_id", columnList = "p_id"),
                @Index(name = "idx_sn_address_name", columnList = "name")
        })
public class SnNationalAddress extends BaseDomain implements Serializable{
    public static final String ADDRESS_LEVEL_COUNTRY= "0";
    public static final String ADDRESS_LEVEL_PROVINCE= "1";
    public static final String ADDRESS_LEVEL_CITY= "2";
    public static final String ADDRESS_LEVEL_AREA= "3";
    public static final String ADDRESS_LEVEL_TOWN= "4";

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    @Column(length = 36)
    private String snAddressId;
    /**
     * 区域编码
     */
    private String id;
    /**
     *父级区域编码
     */
    @Column(name="p_id")
    private String pId;
    /**
     *级别：1.省 2市 3区/ 县 4镇
     */
    @Column(name="sn_level")
    private String snLevel;
    /**
     *名称
     */
    private String name;
    /**
     *Level为4-镇时，有值（对应的市区域编码）
     */
    private String secondPid;
    /**
     *snId+level为唯一标识
     */
    @Column(name="sn_id")
    private String snId;

    @Column(length = 36)
    private String linkId;

    private String parentId;

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getSnAddressId() {
        return snAddressId;
    }

    public void setSnAddressId(String snAddressId) {
        this.snAddressId = snAddressId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getpId() {
        return pId;
    }

    public void setpId(String pId) {
        this.pId = pId;
    }

    public String getSnLevel() {
        return snLevel;
    }

    public void setSnLevel(String snLevel) {
        this.snLevel = snLevel;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecondPid() {
        return secondPid;
    }

    public void setSecondPid(String secondPid) {
        this.secondPid = secondPid;
    }

    public String getSnId() {
        return snId;
    }

    public void setSnId(String snId) {
        this.snId = snId;
    }

    public String getLinkId() {
        return linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SnNationalAddress that = (SnNationalAddress) o;

        return snAddressId != null ? snAddressId.equals(that.snAddressId) : that.snAddressId == null;

    }

    @Override
    public int hashCode() {
        return snAddressId != null ? snAddressId.hashCode() : 0;
    }
}
