package suning.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import suning.model.SnNationalAddress;

import java.util.List;

/**
 * Created by Roney on 2017-04-06.
 */

@Transactional
public interface SnNationalAddressRepos extends JpaRepository<SnNationalAddress,String> {

    List<SnNationalAddress> findByLinkId(String linkId);

    @Query("select s from SnNationalAddress s where s.linkId is null")
    List<SnNationalAddress> findByLinkIdIsNull();

    List<SnNationalAddress> findBySnLevelAndParentId(String snLevel,String parentId);

    //SnNationalAddress findBySnId(String s);

    //@Query("select e from SnNationalAddress e where e.pId='523' and e.id='03'")
    SnNationalAddress findByPIdAndId(String pId, String id);


    SnNationalAddress findByPId(String pId);

    SnNationalAddress findByIdAndSnLevel(String id, String snLevel);

    SnNationalAddress findBySnLevelAndSnId(String snLevel, String snId);

    List<SnNationalAddress> findBySnLevel(String snLevel);
}
