package suning.service.apiImpl;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import suning.service.decode.DecodeOutSideAccountService;
import utils.security.AesUtil;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-05.
 */
public class BaseSuNingConfig {

    @Autowired
    DecodeOutSideAccountService decodeOutSideAccountService;

    @Value("${suning.serverUrl}")
    public String serverUrl;//url

    @Value("${suning.appKey}")
    public String appKey;//key


    @Value("${suning.appSecret}")
    public String appSecret;//secret


    @Value("${suning.format}")
    public String format;//格式化

    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }


    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        setAppKey(AesUtil.Decrypt(appKey, decodeOutSideAccountService.getSuningAppDecodeKey()));
        setAppSecret(AesUtil.Decrypt(appSecret, decodeOutSideAccountService.getSuningAppDecodeSecret()));
    }
}
