package suning.service.apiImpl.good;

import com.alibaba.fastjson.JSON;
import com.suning.api.DefaultSuningClient;
import com.suning.api.entity.govbus.CategoryGetRequest;
import com.suning.api.entity.govbus.CategoryGetResponse;
import com.suning.api.exception.SuningApiException;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import suning.api.good.SnCategoryApi;
import suning.service.apiImpl.BaseSuNingConfig;
import suning.service.service.SnSystemLogService;
import utils.log.Log;
import utils.log.Logs;

/**
 * Created by Roney on 2017-03-28.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SnCategoryApiImpl extends BaseSuNingConfig implements SnCategoryApi {
    private final static Log log = Logs.getLog(SnCategoryApiImpl.class.getName());
    @Autowired
    SnSystemLogService snSystemLogService;
    @Override
    public CategoryGetResponse getCategory(CategoryGetRequest request) {

        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            CategoryGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

           log.info("response.getBody(){} :" , response.getBody());
            return response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }
}
