package suning.service.apiImpl.good;

import com.alibaba.fastjson.JSON;
import com.suning.api.DefaultSuningClient;
import com.suning.api.entity.govbus.*;
import com.suning.api.exception.SuningApiException;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import suning.api.good.SnProductApi;
import suning.service.apiImpl.BaseSuNingConfig;
import suning.service.service.SnSystemLogService;
import utils.log.Log;
import utils.log.Logs;

/**
 * Created by Roney on 2017-03-28.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SnProductApiImpl extends BaseSuNingConfig implements SnProductApi {
    private final static Log log = Logs.getLog(SnProductApiImpl.class.getName());

    @Autowired
    SnSystemLogService snSystemLogService;
    @Override
    public ProdPoolQueryResponse queryProdPool(ProdPoolQueryRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            ProdPoolQueryResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

            log.info("response.getBody(){} :" , response.getBody());
            return response;

        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public JudgefacproductGetResponse getJudgefacProduct(JudgefacproductGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            JudgefacproductGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

            log.info("response.getBody(){} :" , response.getBody());
            return response;

        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ProdDetailGetResponse getProdDetail(ProdDetailGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            ProdDetailGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

            log.info("response.getBody(){} :" , response.getBody());
            return response;

        } catch (SuningApiException e) {
            //保存错误信息
            //snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ProdImageQueryResponse queryProdImage(ProdImageQueryRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            ProdImageQueryResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

            log.info("response.getBody(){} :" , response.getBody());
            return response;

        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public BatchProdSaleStatusGetResponse getBatchProdSaleStatus(BatchProdSaleStatusGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            BatchProdSaleStatusGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

            log.info("response.getBody(){} :" , response.getBody());
            return response;

        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ProdReviewQueryResponse queryProdReview(ProdReviewQueryRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            ProdReviewQueryResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

            log.info("response.getBody(){} :" , response.getBody());
            return response;

        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ProdextendGetResponse getProdextend(ProdextendGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey, appSecret, format);

        try {
            log.info("request{} :" , JSON.toJSONString(request));
            //得到请求结果
            ProdextendGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return response;

        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }
}
