package suning.service.apiImpl.invoice;

import com.suning.api.DefaultSuningClient;
import com.suning.api.entity.govbus.InvoiceConfirmRequest;
import com.suning.api.entity.govbus.InvoiceConfirmResponse;
import com.suning.api.exception.SuningApiException;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import suning.api.invoice.SnInvoiceApi;
import suning.service.apiImpl.BaseSuNingConfig;
import suning.service.service.SnSystemLogService;
import utils.log.Log;
import utils.log.Logs;

/**
 * Created by Roney on 2017-04-05.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SnInvoiceApiImpl extends BaseSuNingConfig implements SnInvoiceApi {
    private final static Log log = Logs.getLog(SnInvoiceApiImpl.class.getName());

    @Autowired
    SnSystemLogService snSystemLogService;
    @Override
    public InvoiceConfirmResponse confirm(InvoiceConfirmRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            InvoiceConfirmResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);

            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }
}
