package suning.service.apiImpl.other;

import com.suning.api.DefaultSuningClient;
import com.suning.api.entity.govbus.MessageDeleteRequest;
import com.suning.api.entity.govbus.MessageDeleteResponse;
import com.suning.api.entity.govbus.MessageGetRequest;
import com.suning.api.entity.govbus.MessageGetResponse;
import com.suning.api.exception.SuningApiException;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import suning.api.other.SnMessageApi;
import suning.service.apiImpl.BaseSuNingConfig;
import suning.service.service.SnSystemLogService;
import utils.log.Log;
import utils.log.Logs;

/**
 * Created by Roney on 2017-04-05.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SnMessageApiImpl extends BaseSuNingConfig implements SnMessageApi {
    private final static Log log = Logs.getLog(SnMessageApiImpl.class.getName());
    @Autowired
    SnSystemLogService snSystemLogService;
    @Override
    public MessageGetResponse get(MessageGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            MessageGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public MessageDeleteResponse delete(MessageDeleteRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            MessageDeleteResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }
}
