package suning.service.apiImpl.shipping;

import com.suning.api.DefaultSuningClient;
import com.suning.api.entity.govbus.*;
import com.suning.api.exception.SuningApiException;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;
import suning.api.shipping.SnShippingApi;
import suning.service.apiImpl.BaseSuNingConfig;
import suning.service.service.SnSystemLogService;
import utils.log.Log;
import utils.log.Logs;

/**
 * Created by Roney on 2017-04-05.
 */
@MotanService(basicService = "motanServerBasicConfig")
public class SnShippingApiImpl extends BaseSuNingConfig implements SnShippingApi {
    private final static Log log = Logs.getLog(SnShippingApiImpl.class.getName());

    @Autowired
    SnSystemLogService snSystemLogService;
    @Override
    public OrderLogistGetResponse getOrderLogist(OrderLogistGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            OrderLogistGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public OrderlogistnewGetResponse getOrderLogistNew(OrderlogistnewGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            OrderlogistnewGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ShipTimeGetResponse getShipTime(ShipTimeGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            ShipTimeGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ShipCarriageGetResponse getShipCarriage(ShipCarriageGetRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            ShipCarriageGetResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public FacProductConfirmResponse confirmFacProduct(FacProductConfirmRequest request) {
        DefaultSuningClient client = new DefaultSuningClient(serverUrl, appKey,appSecret, format);

        try {

            //得到请求结果
            FacProductConfirmResponse response = client.excute(request);
            //保存返回结果和请求结果
            snSystemLogService.asyncSysLog(request,response,null,null);
            log.info("response.getBody(){} :" , response.getBody());
            return  response;
        } catch (SuningApiException e) {
            //保存错误信息
            snSystemLogService.asyncSysLog(null,null,null,e.getErrMsg());
            e.printStackTrace();
        }
        return null;
    }
}
