package suning.service.controller;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnAddressService;
import sysmg.api.SystemLogApi;
import utils.GlobalContants;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-05.
 */

@Controller
@RequestMapping("address")
public class SnAddressController {


    @Value("${suning.api.initPassword}")
    private String password ;
    @Autowired
    SnAddressService snAddressService;
    @MotanReferer
    SystemLogApi systemLogApi;

    @RequestMapping(value = "initAddress",method = RequestMethod.GET)
    @ResponseBody
    public Map initAddress(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
//       TextToFile("d://ss.txt", JSONObject.toJSONString(snAddressService.getFullAddress()));
//        GzipUtils.gzipData(JSONObject.toJSONString(snAddressService.getFullAddress()));
        return  snAddressService.getFullAddress();

    }

    @RequestMapping(value = "syncAddress",method = RequestMethod.GET)
    @ResponseBody
    public Map syncAddress(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        returnMap=snAddressService.syncFullAddress();
       // List<SystemLog> systemLogs=new ArrayList<>();
        //SystemLog systemLog=new SystemLog(SystemLog.LOG_TYPE_INFO,JSONObject.toJSONString(returnMap));
        //systemLogs.add(systemLog);
        //systemLogApi.saveBeans(systemLogs);
        return returnMap;
    }

    @RequestMapping(value = "addParentId",method = RequestMethod.GET)
    @ResponseBody
    public String addParentId(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return "error";
        }
        snAddressService.addParentId();
        return "success";
    }

    @RequestMapping(value = "addSingleParentId",method = RequestMethod.GET)
    @ResponseBody
    public String addSingleParentId(String password,String id) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return "error";
        }
        snAddressService.addSingleParentId(id);
        return "success";
    }

    @RequestMapping(value = "deleteAllAddress",method = RequestMethod.GET)
    @ResponseBody
    public String deleteAllAddress(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return "error";
        }
        snAddressService.deleteFullAddress();
        return "success";
    }

    @RequestMapping("linkLevelThreeAddress")
    @ResponseBody
    public String linkLevelThreeAddress(){
        snAddressService.linkLevelThreeAddress();
        return "linkLevelThreeAddress";
    }

    @RequestMapping("linkLevelFourAddress")
    @ResponseBody
    public String linkLevelFourAddress(){
        snAddressService.linkLevelFourAddress();
        return "linkLevelFourAddress";
    }


    public void TextToFile(final String strFilename, final String strBuffer)
    {
        try
        {
            // 创建文件对象
            File fileText = new File(strFilename);
            // 向文件写入对象写入信息
            FileWriter fileWriter = new FileWriter(fileText);

            // 写文件
            fileWriter.write(strBuffer);
            // 关闭
            fileWriter.close();
        }
        catch (IOException e)
        {
            //
            e.printStackTrace();
        }
    }

}
