package suning.service.controller;

import com.suning.api.entity.govbus.MessageDeleteRequest;
import com.suning.api.entity.govbus.MessageGetRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnMessageService;
import utils.GlobalContants;
import utils.log.Log;
import utils.log.Logs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-07.
 */
@Controller
@RequestMapping("message")
public class SnMessageController {
    private final static Log log = Logs.getLog(SnMessageController.class.getName());


    @Value("${suning.api.initPassword}")
    private String password ;

    @Autowired
    SnMessageService snMessageService;

    @RequestMapping(value = "get",method = RequestMethod.GET)
    @ResponseBody
    public Map get(String password,@RequestParam(value="type") String type){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        MessageGetRequest request = new MessageGetRequest();
        request.setType(type);
        returnMap.put("result",  snMessageService.get(request));
        return returnMap;
    }

    @RequestMapping(value = "delete",method = RequestMethod.GET)
    @ResponseBody
    public Map delete(String password,String messageId){
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        MessageDeleteRequest request = new MessageDeleteRequest();
        request.setId(messageId);
        returnMap.put("result",  snMessageService.delete(request));
        return returnMap;

    }

}
