package suning.service.controller;

import com.suning.api.entity.govbus.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnOrderService;
import utils.GlobalContants;
import utils.log.Log;
import utils.log.Logs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-07.
 */
@Controller
@RequestMapping("order")
public class SnOrderController {
    private final static Log log = Logs.getLog(SnOrderController.class.getName());


    @Value("${suning.api.initPassword}")
    private String password ;

    @Autowired
    SnOrderService snOrderService;

    @RequestMapping(value = "addOrder",method = RequestMethod.GET)
    @ResponseBody
    public Map addOrder(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        OrderAddRequest request = new OrderAddRequest();
        return snOrderService.addOrder(request);
    }

    @RequestMapping(value = "addApplyRejected",method = RequestMethod.GET)
    @ResponseBody
    public Map addApplyRejected(String password, String orderId) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        ApplyRejectedAddRequest request = new ApplyRejectedAddRequest();
        request.setOrderId(orderId);
        return snOrderService.addApplyRejected(request);
    }

    @RequestMapping(value = "addConfirmOrder",method = RequestMethod.GET)
    @ResponseBody
    public Map addConfirmOrder(String password, String orderId) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        ConfirmOrderAddRequest request = new ConfirmOrderAddRequest();
        request.setOrderId(orderId);
        return snOrderService.addConfirmOrder(request);
    }

    @RequestMapping(value = "batchConfirmOrder",method = RequestMethod.GET)
    @ResponseBody
    public Map batchConfirmOrder(String password, String[] orderids) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        ConfirmOrderAddRequest request = new ConfirmOrderAddRequest();
        for(int i=0 ;i<orderids.length;i++) {
            String orderId=orderids[i];
            request.setOrderId(orderId);
            returnMap.put(orderId,snOrderService.addConfirmOrder(request));
        }

        return returnMap;
    }

    @RequestMapping(value = "deleteRejectOrder",method = RequestMethod.GET)
    @ResponseBody
    public Map deleteRejectOrder(String password, String orderId) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        RejectOrderDeleteRequest request = new RejectOrderDeleteRequest();
        request.setOrderId(orderId);
        return snOrderService.deleteRejectOrder(request);
    }

    @RequestMapping(value = "getOrderDetail",method = RequestMethod.GET)
    @ResponseBody
    public Map getOrderDetail(String password, String orderId) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        OrderDetailGetRequest request = new OrderDetailGetRequest();
        request.setOrderId(orderId);
        return snOrderService.getOrderDetail(request);
    }

    @RequestMapping(value = "getOrderStatus",method = RequestMethod.GET)
    @ResponseBody
    public Map getOrderStatus(String password, String orderId) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        OrderStatusGetRequest request = new OrderStatusGetRequest();
        request.setOrderId(orderId);
        returnMap.put("result",snOrderService.getOrderStatus(request));
        return returnMap;
    }

    @RequestMapping("/cancelOrder")
    @ResponseBody
    public Map cancelOrder(@RequestParam(name = "snOrderIds[]", required = true) String[] snOrderIds) {
        Map returnMap=new HashMap();
        for(int i=0;i<snOrderIds.length;i++) {
            RejectOrderDeleteRequest request = new RejectOrderDeleteRequest();
            request.setOrderId(snOrderIds[i]);
           // return snOrderService.deleteRejectOrder(request);

            returnMap.put(snOrderIds[i],snOrderService.deleteRejectOrder(request));
        }
        return returnMap;
    }

}
