package suning.service.controller;

import com.alibaba.fastjson.JSONArray;
import com.suning.api.entity.govbus.InventoryGetRequest;
import com.suning.api.entity.govbus.MpStockQueryRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnProdService;
import suning.service.service.SnStockService;
import utils.GlobalContants;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.util.*;

/**
 * Created by Roney on 2017-04-07.
 */
@Controller
@RequestMapping("stock")
public class SnStockController {
    private final static Log log = Logs.getLog(SnStockController.class.getName());


    @Value("${suning.api.initPassword}")
    private String password ;
    @RequestMapping(value = "getInventory",method = RequestMethod.GET)
    @ResponseBody
    public Map getInventory(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        Map map = new HashMap();

        return map;
    }

    @Autowired
    SnStockService snStockService;

    @RequestMapping(value = "queryInvoice",method = RequestMethod.GET)
    @ResponseBody
    public Map queryInvoice(@RequestParam(value="skuid") String skuid,String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        InventoryGetRequest request = new InventoryGetRequest();
        List<InventoryGetRequest.SkuIds> skuIdses = new ArrayList<>();
        InventoryGetRequest.SkuIds skuIds = new InventoryGetRequest.SkuIds();
        skuIds.setSkuId(skuid);
        skuIdses.add(skuIds);
        request.setSkuIds(Arrays.asList(skuIds));
        request.setCityId("010");
        request.setCountyId("10");
//api入参校验逻辑开关，当测试稳定之后建议设置为 false 或者删除该行
        request.setCheckParam(true);
        return  snStockService.getInventory(request);
    }

    @RequestMapping(value = "queryMprodStock",method = RequestMethod.GET)
    @ResponseBody
    public Map queryMprodStock(@RequestParam(value="skuid")String skuid,String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        MpStockQueryRequest request = new MpStockQueryRequest();
        List<MpStockQueryRequest .SkuIds> skuIdses = new ArrayList<>();
        MpStockQueryRequest .SkuIds skuIds = new MpStockQueryRequest .SkuIds();
        skuIds.setSkuId(skuid);
        skuIdses.add(skuIds);
        request.setSkuIds(skuIdses);
        request.setCityId("010");
//api入参校验逻辑开关，当测试稳定之后建议设置为 false 或者删除该行
        request.setCheckParam(true);
        return  snStockService.queryMprodStock(request);

    }

    @RequestMapping(value = "queryGoodsMprodStock",method = RequestMethod.GET)
    @ResponseBody
    public Map queryGoodsMprodStock(String password,String cityId,@RequestParam(name = "skus[]", required = true) String[] skus ) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }

        if(Lang.isEmpty(cityId)){
            cityId="010";
        }
        List<Map<String,String>> params = new ArrayList<>();
        for(int i=0;i<skus.length;i++){
            Map<String,String>  addParams=new HashMap<>();
            addParams.put("skuId",skus[i]);
            params.add(addParams);
        }
        /*String skuIdsStr = "[{'skuId':'101199489'},{'skuId':'121289049'},{'skuId':'121306081'},{'skuId':'121307256'},{'skuId':'121345083'},{'skuId':'121347375'},{'skuId':'150042850'}" +
                ",{'skuId':'121345089'},{'skuId':'121289048'},{'skuId':'121317086'},{'skuId':'121347616'},{'skuId':'121347622'},{'skuId':'150042849'}]";*/

        returnMap.put("result",snStockService.queryGoodsMprodStock(params,cityId));
        return  returnMap;
    }

    @RequestMapping(value = "queryGoodsInvoice",method = RequestMethod.GET)
    @ResponseBody
    public Map queryGoodsInvoice(String password) {
        Map returnMap=new HashMap();
        if(!StringUtils.equals(this.password,password)){
            returnMap.put(GlobalContants.ResponseString.MESSAGE,"error password");
            return returnMap;
        }
        /*String skuIdsStr = "[{'skuId':'101199489','num':'10'},{'skuId':'121289049','num':'10'},{'skuId':'121306081','num':'10'},{'skuId':'121307256','num':'10'},{'skuId':'121345083','num':'10'},{'skuId':'121347375','num':'10'},{'skuId':'150042850','num':'10'}" +
                ",{'skuId':'121345089','num':'10'},{'skuId':'121289048','num':'10'},{'skuId':'121317086','num':'10'},{'skuId':'121347616','num':'10'},{'skuId':'121347622','num':'10'},{'skuId':'150042849','num':'10'}]";*/
        List<Map<String,String>> params = new ArrayList<>();
        returnMap.put("result",snStockService.getGoodsInventory(params,"010","10"));
        return  returnMap;
    }

}
