package suning.service.decode;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import utils.Lang;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

/**
 * Created by oracle on 2017-08-24.
 */

/**
 * 太平要求对外围系统账号使用aes对称加密，并且在启动服务时输入账号密码
 */
@Component
@Order(-1000)
public class DecodeOutSideAccountService {
    Logger logger = LoggerFactory.getLogger(getClass());
    private String suningAppDecodeKey;
    private String suningAppDecodeSecret;

    @Value("${spring.profiles.active}")
    private String activeEnv;

    @PostConstruct
    public void importSecretKey() {
        try {
            Map<String, Object> keysMap = new HashMap<>();

            String key = null;
            Scanner scanner = null;

            Boolean readPassword=false;
            /** 非生产环境不调用接口 */
            if (!Lang.isEmpty(this.activeEnv)) {
                String[] envArr = this.activeEnv.split(",");
                for (String env : envArr) {
                    if ("readPassword".equals(env.trim()) ) {
                        readPassword=true;
                    }
                }
            }

            if(!readPassword) {
                scanner = new Scanner(System.in);

            }

            /**
             * 苏宁密钥
             */
            System.out.println("请输入suning.appKey密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="iiiiiiiiiiiiiiii";
            }

            setSuningAppDecodeKey(key);
            System.out.println("请输入suning.appSecret密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="jjjjjjjjjjjjjjjj";
            }
            setSuningAppDecodeSecret(key);
            System.out.println("苏宁密钥输入完成！ ");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getAndcheckRepeatKey(Map<String, Object> keysMap, Scanner scanner) {
        String key = scanner.next();
        while (StringUtils.isEmpty(key) || key.length() != 16 || keysMap.containsKey(key)) {
            if (StringUtils.isEmpty(key)) {
                System.out.println("密钥不能为空,请重新输入");
            } else if (key.length() != 16) {
                System.out.println("密钥格式不正确,请重新输入");
            } else if (keysMap.containsKey(key)) {
                System.out.println("不能使用相同密钥,请重新输入");
            }
            key = scanner.next();
        }
        keysMap.put(key, null);
        return key;
    }

    public String getSuningAppDecodeKey() {
        return suningAppDecodeKey;
    }

    public void setSuningAppDecodeKey(String suningAppDecodeKey) {
        this.suningAppDecodeKey = suningAppDecodeKey;
    }

    public String getSuningAppDecodeSecret() {
        return suningAppDecodeSecret;
    }

    public void setSuningAppDecodeSecret(String suningAppDecodeSecret) {
        this.suningAppDecodeSecret = suningAppDecodeSecret;
    }
}
