package suning.service.dev;

import goods.model.ProductCategory;
import goods.model.repository.ProductCategoryRepos;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import suning.model.TestMatchCategoryData;
import suning.model.repository.TMCDRepo;
import utils.Lang;
import utils.excel.ReadExcelUtil;
import utils.log.Log;
import utils.log.Logs;

import javax.annotation.PostConstruct;
import java.io.File;
import java.util.List;

/**
 * Created by Roney on 2017-07-17.
 */
@Component
@Profile("dbInit")
public class DbInit {

    private final static Log log = Logs.getLog(DbInit.class.getName());
    @Autowired
    ProductCategoryRepos productCategoryRepos;

    @Autowired
    TMCDRepo tMCDRepo;

    @Value("${suning.store.code}")
    private String sn_code;

    @Value("${suning.store.id}")
    private String sn_id;
    @PostConstruct
    @Transactional
    public void initData() {
        initMatchData();
       // initProductCategory();
    }

    public void initProductCategory() {
        log.info("初始化苏宁分类数据开始 ========================= ");
        File file = new File("c:\\temp/苏宁分类.xlsx");

        try {
            List excel = ReadExcelUtil.readExcel(file);
            excel.remove(excel.get(0));
            int dataCount = 0;
            int querySuccessCount=0;
            for(int i=1;i<excel.size();i++){
                List resultList= (List) excel.get(i);

                String categoryName = (String) resultList.get(4);

                ProductCategory queryProdCat=new ProductCategory();
                queryProdCat.setName(categoryName);
                queryProdCat.setLayerIndex(3);
                //queryProdCat.setIsDelete(false);
                List<ProductCategory> productCategorys=productCategoryRepos.findAll(Example.of(queryProdCat));

                ProductCategory productCategory=null;
                // String productCategoryId = "";
                if(!Lang.isEmpty(productCategorys)&& productCategorys.size()>=0){
                    querySuccessCount++;
                    productCategory=productCategorys.get(0);
                    log.info("productCategoryName"+productCategory.getName());
                }else{//查询不到，将数据新增，然后将分类信息记录下来，人工维护
                    productCategory=new ProductCategory();
                    productCategory.setLayerIndex(1);//设置为一级
                    productCategory.setSourceCode(sn_code);
                    productCategory.setName(categoryName);
                    log.info("productCategoryName"+productCategory.getName());
                    // productCategoryRepos.save(productCategory);
                    log.info("查询不到，将数据新增，然后将分类信息记录下来，人工维护;分类名称："+categoryName);
                }


                dataCount++;
            }


            log.info("querySuccessCount:" + querySuccessCount);
            log.info("dataCount:" + dataCount);
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("初始化苏宁分类数据完成 ========================= ");
    }

    public void initMatchData() {
        log.info("初始化苏宁分类数据开始 ========================= ");
        File file = new File("c:\\temp/苏宁京东分类关联.xlsx");

        try {
            List excel = ReadExcelUtil.readExcel(file);
            excel.remove(excel.get(0));
            excel.remove(excel.get(1));
            int dataCount = 0;
            int querySuccessCount=0;
            for(int i=0;i<excel.size();i++){
                List resultList= (List) excel.get(i);

                String categorySnOneName = (String) resultList.get(0);
                String categorySnTwoName = (String) resultList.get(1);
                String categorySnThreeName = (String) resultList.get(2);
                String categoryJdOneName = (String) resultList.get(3);
                String categoryJdTwoName = (String) resultList.get(4);
                String categoryJdThreeName = (String) resultList.get(5);

                TestMatchCategoryData testMatchCategoryData=new TestMatchCategoryData(categorySnOneName,categorySnTwoName,categorySnThreeName,categoryJdOneName,categoryJdTwoName,categoryJdThreeName);
//                TestMatchCategoryData testMatchCategoryData=new TestMatchCategoryData();
//                testMatchCategoryData.setSnThreeCat(categorySnThreeName);
//                testMatchCategoryData.setJdThreeCat(categoryJdThreeName);
                tMCDRepo.save(testMatchCategoryData);

                dataCount++;
            }


            log.info("querySuccessCount:" + querySuccessCount);
            log.info("dataCount:" + dataCount);
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("初始化苏宁分类数据完成 ========================= ");
    }
}
