package suning.service.service;

import com.suning.api.entity.govbus.FullAddressGetRequest;
import com.suning.api.entity.govbus.FullAddressGetResponse;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.AddressCommonApi;
import member.model.common.Address;
import member.model.repository.common.AddressRepos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import suning.api.address.SnAddressApi;
import suning.model.SnAddressRelation;
import suning.model.SnNationalAddress;
import suning.model.repository.SnAddressRelationRepos;
import suning.model.repository.SnNationalAddressRepos;
import utils.Lang;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by Roney on 2017-04-05.
 */
@Component
public class SnAddressService{
    @Autowired
    SnAddressApi snAddressApi;

    @Autowired
    SnNationalAddressRepos snNationalAddressRepos;

    @MotanReferer
    AddressCommonApi addressCommonApi;

    /**
     * 返回下属地区列表
     *
     * @param snNationalAddress
     * @return
     */
    public List<SnNationalAddress> getChildAddressList(SnNationalAddress snNationalAddress) {
        Assert.notNull(snNationalAddress.getSnLevel(), "SnNationalAddress.snLevel should not be null");
        Assert.notNull(snNationalAddress.getParentId(), "SnNationalAddress.parentId should not be null");
        return snNationalAddressRepos.findBySnLevelAndParentId((Integer.valueOf(snNationalAddress.getSnLevel()) + 1) + "", snNationalAddress.getSnId());
    }

    /**
     * 返回父级地址
     *
     * @param snNationalAddress
     * @return
     */
    public SnNationalAddress findParentAddress(SnNationalAddress snNationalAddress) {
        Assert.notNull(snNationalAddress.getSnLevel(), "SnNationalAddress.snLevel should not be null");
        Assert.notNull(snNationalAddress.getSnId(), "SnNationalAddress.parentId should not be null");
        return snNationalAddressRepos.findBySnLevelAndSnId((Integer.valueOf(snNationalAddress.getSnLevel()) - 1) + "", snNationalAddress.getParentId());
    }

    public Map getFullAddress() {
        Map returnMap = new HashMap();
        FullAddressGetRequest request = new FullAddressGetRequest();
//api入参校验逻辑开关，当测试稳定之后建议设置为 false 或者删除该行
        request.setCheckParam(true);
        //FullAddressGetResponse fullAddressGetResponse=snAddressApi.getFullAddress(request);
        // for(int i=0;i<fullAddressGetResponse.getBody())
        returnMap.put("result", snAddressApi.getFullAddress(request));
        return returnMap;
    }

    class AddressThread extends Thread {
        FullAddressGetResponse.ResultInfo resultInfo;

        AddressThread(FullAddressGetResponse.ResultInfo resultInfo) {
            this.resultInfo = resultInfo;
        }

        @Override
        public void run() {
            addAddress(resultInfo);
        }
    }

    private void addAddress(FullAddressGetResponse.ResultInfo addr) {
        List<SnNationalAddress> saveAddrList = new ArrayList<SnNationalAddress>();
        SnNationalAddress snNationalAddress = new SnNationalAddress();
        snNationalAddress.setId(addr.getId());
        snNationalAddress.setpId(addr.getpId());
        snNationalAddress.setName(addr.getName());
        snNationalAddress.setSnId(addr.getSnId());
        if (SnNationalAddress.ADDRESS_LEVEL_COUNTRY.equals(addr.getLevel())) {
            List<Address> addresses = addressRepos.findByShortNameAndLevelType(addr.getName(), SnNationalAddress.ADDRESS_LEVEL_COUNTRY);
            if (!Lang.isEmpty(addresses)) {
                if (addresses.size() >= 0) {
                    snNationalAddress.setLinkId(addresses.get(0).getId());
                }
            }
        } else if (SnNationalAddress.ADDRESS_LEVEL_PROVINCE.equals(addr.getLevel())) {
            List<Address> addresses = addressRepos.findByShortNameAndLevelType(addr.getName(), SnNationalAddress.ADDRESS_LEVEL_PROVINCE);
            if (!Lang.isEmpty(addresses)) {
                if (addresses.size() >= 0) {
                    snNationalAddress.setLinkId(addresses.get(0).getId());
                }
            }
        } else if (SnNationalAddress.ADDRESS_LEVEL_CITY.equals(addr.getLevel())) {
            List<Address> addresses = addressRepos.findByNameAndLevelType(addr.getName(), SnNationalAddress.ADDRESS_LEVEL_CITY);
            if (!Lang.isEmpty(addresses)) {
                if (addresses.size() >= 0) {
                    snNationalAddress.setLinkId(addresses.get(0).getId());
                }
            }
        } else if (SnNationalAddress.ADDRESS_LEVEL_AREA.equals(addr.getLevel())) {
            List<Address> addresses = addressRepos.findByNameAndLevelType("%" + addr.getName() + "%", SnNationalAddress.ADDRESS_LEVEL_AREA);
            if (!Lang.isEmpty(addresses)) {
                if (addresses.size() >= 0) {
                    snNationalAddress.setLinkId(addresses.get(0).getId());
                }
            }
        } else if (SnNationalAddress.ADDRESS_LEVEL_TOWN.equals(addr.getLevel())) {
            List<Address> addresses = addressRepos.findByNameAndLevelType(addr.getName(), SnNationalAddress.ADDRESS_LEVEL_TOWN);
            if (!Lang.isEmpty(addresses)) {
                if (addresses.size() >= 0) {
                    snNationalAddress.setLinkId(addresses.get(0).getId());
                }
            }
            snNationalAddress.setSecondPid(addr.getSecondPid());
        }
        snNationalAddress.setSnLevel(addr.getLevel());
        saveAddrList.add(snNationalAddress);
        snNationalAddressRepos.save(saveAddrList);
    }

    public final static Logger logger = LoggerFactory.getLogger(SnAddressService.class);

    //step 1
    public void addParentId() {
        List<SnNationalAddress> snNationalAddresses = snNationalAddressRepos.findAll();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        for (final SnNationalAddress snNationalAddress : snNationalAddresses) {
            executorService.execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        SnNationalAddress snAddr = null;
                        if (Lang.equals(snNationalAddress.getSnLevel(), "2") || Lang.equals(snNationalAddress.getSnLevel(), "3")) {
                            Integer i = Integer.valueOf(snNationalAddress.getSnLevel()) - 1;
                            snAddr = snNationalAddressRepos.findByIdAndSnLevel(snNationalAddress.getpId(), i.toString());
                            snNationalAddress.setParentId(snAddr.getSnId() + snAddr.getSnLevel());
                            snNationalAddressRepos.save(snNationalAddress);
                        } else if (Lang.equals(snNationalAddress.getSnLevel(), "4")) {
                            snAddr = snNationalAddressRepos.findByPIdAndId(snNationalAddress.getSecondPid(), snNationalAddress.getpId());
                            snNationalAddress.setParentId(snAddr.getSnId());
                            snNationalAddressRepos.save(snNationalAddress);
                        }
                    } catch (Exception e) {
                        System.out.println("snid========" + snNationalAddress.getSnId());
                        logger.error(e.getMessage(), e);
                    }
                }
            });

        }
        if(!executorService.isShutdown()) {
            executorService.shutdown();
        }
    }

    /**
     * 关联苏宁地址与主地址
     *  step 0  关联苏宁自身的各级地址，为每个2,3,4级地址添加parent_id
     */
    public void addSingleParentId(String id) {
        SnNationalAddress snNationalAddress = snNationalAddressRepos.findOne(id);
        try {
            SnNationalAddress snAddr = null;
            if (Lang.equals(snNationalAddress.getSnLevel(), "2") || Lang.equals(snNationalAddress.getSnLevel(), "3")) {
                Integer i = Integer.valueOf(snNationalAddress.getSnLevel()) - 1;
                snAddr = snNationalAddressRepos.findByIdAndSnLevel(snNationalAddress.getpId(), i.toString());
                snNationalAddress.setParentId(snAddr.getSnId());
                snNationalAddressRepos.save(snNationalAddress);
            } else if (Lang.equals(snNationalAddress.getSnLevel(), "4")) {
                snAddr = snNationalAddressRepos.findByPIdAndId(snNationalAddress.getSecondPid(), snNationalAddress.getpId());
                snNationalAddress.setParentId(snAddr.getSnId());
                snNationalAddressRepos.save(snNationalAddress);
            }
        } catch (Exception e) {
            System.out.println("snid========" + snNationalAddress.getSnId());
            logger.error(e.getMessage(), e);
        }
    }

    public void addLinkIdJob() {
        ExecutorService pool = Executors.newFixedThreadPool(10);
    }

    @Autowired
    AddressRepos addressRepos;
    @Autowired
    SnAddressRelationRepos snAddressRelationRepos;

    public void addLinkId() {

    }

    /**
     * 关联苏宁地址与主地址
     *  step 2 关联苏宁的三级地址与主地址表的三级，因为各级地址存在重名的可能性，所以事先确定第三级的关联，解决名字冲突
     *  之后的任务，直接将苏宁的各个具体得三级地址下的四级和主地址表三级地址下的各个具体的四级地址关联。
     */
    public void linkLevelThreeAddress() {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        List<SnNationalAddress> snNationalAddresses = snNationalAddressRepos.findBySnLevel("3");
        for (final SnNationalAddress snNationalAddress : snNationalAddresses) {
            pool.execute(new Runnable() {
                @Override
                public void run() {
                    List<Address> addresses = addressRepos.findByNameAndLevelType(snNationalAddress.getName(), "3");
                    if (Lang.isEmpty(addresses)) {
                        String name = snNationalAddress.getName();
                        name = name.replace("区", "");
                        name = name.replace("县", "");
                        name = name.replace("市", "");
                        List<Address> addressesFindByShortName = addressRepos.findByShortNameAndLevelType(name, "3");
                        if (Lang.isEmpty(addressesFindByShortName)) {
                            SnNationalAddress parentAddress = findParentAddress(snNationalAddress);
                            System.out.println(parentAddress.getName() + ":" + snNationalAddress.getName() + "未匹配到数据");
                        } else if (addressesFindByShortName.size() > 1) {
                            System.out.println(name + "匹配到" + addressesFindByShortName.size() + "条数据");
                            SnNationalAddress parentAddress = findParentAddress(snNationalAddress);
                            boolean flag = false;
                            for (Address address : addressesFindByShortName) {
                                if (address.getMergerName().split(";")[2].equals(parentAddress.getName())) {
                                    snNationalAddress.setLinkId(address.getId());
                                    snNationalAddressRepos.save(snNationalAddress);
                                    System.out.println("但是找到了一条匹配的");
                                    flag = true;
                                    break;
                                }
                            }
                            if (!flag) {
                                System.out.println("可惜没有一条匹配");
                            }
                        } else {
                            snNationalAddress.setLinkId(addressesFindByShortName.get(0).getId());
                            snNationalAddressRepos.save(snNationalAddress);
                        }
                    } else if (addresses.size() > 1) {
                        System.out.println(snNationalAddress.getName() + "匹配到" + addresses.size() + "条数据");
                        SnNationalAddress parentAddress = findParentAddress(snNationalAddress);
                        boolean flag = false;
                        for (Address address : addresses) {
                            if (address.getMergerName().split(";")[2].equals(parentAddress.getName())) {
                                snNationalAddress.setLinkId(address.getId());
                                snNationalAddressRepos.save(snNationalAddress);
                                System.out.println("但是找到了一条匹配的");
                                flag = true;
                                break;
                            }
                        }
                        if (!flag) {
                            System.out.println("可惜没有一条匹配");
                        }
                    } else {
                        //匹配到一条
                        snNationalAddress.setLinkId(addresses.get(0).getId());
                        snNationalAddressRepos.save(snNationalAddress);
                    }
                }
            });
        }

        if(!pool.isShutdown()) {
            pool.shutdown();
        }
    }

    @Autowired
    EntityManagerFactory entityManagerFactory;

    /**
     * 关联苏宁地址与主地址
     * step 3 关联四级地址，该方法只关联，不新增
     *
     * 苏宁4级地址特点：  众多的全区，全境等宽泛的概念，无法与具体的主地址表的4级地址对应
     * 解决方案： 使用关联表 多对一映射 多个主地址表4级地址 映射至 全区或者全境
     */
    public void linkLevelFourAddress(){
        //对每个有了三级地址映射（link_id is not null）的地址进行匹配
        System.out.println("开始同步~");
        List<SnNationalAddress> snNationalAddresses = snNationalAddressRepos.findBySnLevel("3");
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        for (final SnNationalAddress snNationalAddress : snNationalAddresses) {
            //为空的个数很少，不需要在加入查询sql的条件中了

            if(!Lang.isEmpty(snNationalAddress.getLinkId())){
                executorService.execute(new Runnable() {
                    @Override
                    public void run() {
                        //打开新线程中的session，避免懒加载问题
                        EntityManager entityManager = entityManagerFactory.createEntityManager();
                        EntityManagerHolder entityManagerHolder = new EntityManagerHolder(entityManager);
                        TransactionSynchronizationManager.bindResource(entityManagerFactory, entityManagerHolder);
                        linkSingleLevelFourAddress(snNationalAddress);
                        TransactionSynchronizationManager.unbindResource(entityManagerFactory);
                        EntityManagerFactoryUtils.closeEntityManager(entityManager);
                    }
                });
            }
        }

        if(!executorService.isShutdown()) {
            executorService.shutdown();
        }
    }

    public void linkSingleLevelFourAddress(SnNationalAddress snNationalAddress) {
        //找出主地址
        Address address = addressRepos.findOne(snNationalAddress.getLinkId());
        //找出苏宁地址
        List<SnNationalAddress> snChildAddresses = getChildAddressList(snNationalAddress);
        //关联
        List<SnAddressRelation> snAddressRelations = new ArrayList<>();
        //找出关联
        for (Address childAddress : address.getChild()) {
            boolean match = false;
            for (SnNationalAddress snChildAddress : snChildAddresses) {
                //名称匹配
                if(snChildAddress.getName().contains(childAddress.getShortName())){
                    snAddressRelations.add(new SnAddressRelation(childAddress.getId(),snChildAddress.getSnAddressId()));
                    match = true;
                    break;
                }
            }
            //未匹配到名称，看看有没有全境或者全区
            if(!match){
                for (SnNationalAddress snChildAddress : snChildAddresses) {
                    //匹配范围
                    if("全区".equals(snChildAddress.getName())||"全境".equals(snChildAddress.getName())){
                        snAddressRelations.add(new SnAddressRelation(childAddress.getId(),snChildAddress.getSnAddressId()));
                        break;
                    }
                }
            }
        }
        snAddressRelationRepos.save(snAddressRelations);
    }

    public Map syncFullAddress() {
        FullAddressGetRequest request = new FullAddressGetRequest();
        //api入参校验逻辑开关，当测试稳定之后建议设置为 false 或者删除该行
        request.setCheckParam(true);
        FullAddressGetResponse response = snAddressApi.getFullAddress(request);
        List<FullAddressGetResponse.ResultInfo> addrList = response.getSnbody().getGetFullAddress().getResultInfo();

        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (int i = 0; i < addrList.size(); i++) {
            try {
                SnAddressService.AddressThread thread = new SnAddressService.AddressThread(addrList.get(i));
                pool.execute(thread);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if(!pool.isShutdown()) {
                    pool.shutdown();
                }
            }
        }
//        for (FullAddressGetResponse.ResultInfo addr: addrList) {
//
//            //snNationalAddressRepo.saveAndFlush(snNationalAddress);
//        }

        System.out.println("=========地址同步完成=========");
        Map map = new HashMap();
        map.put("msg", "地址同步完成");
        return map;
    }

    public Map deleteFullAddress() {
        snNationalAddressRepos.deleteAll();

        Map map = new HashMap();
        map.put("msg", "地址删除完成");
        return map;
    }

//    public static void main(String[] args) {
//        Set<String> set1 = Sets.newHashSet(("永丰镇," +
//                "李中镇," +
//                "昌荣镇," +
//                "竹泓镇," +
//                "老圩乡," +
//                "唐刘镇," +
//                "钓鱼镇," +
//                "沙沟镇," +
//                "陈堡镇," +
//                "城东镇," +
//                "合陈镇," +
//                "中堡镇," +
//                "新垛镇," +
//                "昭阳镇," +
//                "兴化开发区," +
//                "主城区," +
//                "西郊镇," +
//                "陶庄镇," +
//                "戴南镇," +
//                "林湖乡," +
//                "大邹镇," +
//                "沈伦镇," +
//                "荻垛镇," +
//                "周奋乡," +
//                "边城镇," +
//                "安丰镇," +
//                "临城镇," +
//                "茅山镇," +
//                "大营镇," +
//                "西鲍乡," +
//                "戴窑镇," +
//                "大垛镇," +
//                "张郭镇," +
//                "缸顾乡," +
//                "海南镇," +
//                "垛田镇," +
//                "周庄镇," +
//                "下圩镇," +
//                "良种场").split(","));
//
//        Set<String> set2 = Sets.newHashSet(("老圩乡," +
//                "李中镇," +
//                "缸顾乡," +
//                "昭阳镇," +
//                "周庄镇," +
//                "荻垛镇," +
//                "下圩镇," +
//                "沙沟镇," +
//                "戴窑镇," +
//                "林湖乡," +
//                "钓鱼镇," +
//                "西鲍乡," +
//                "大垛镇," +
//                "大邹镇," +
//                "合陈镇," +
//                "张郭镇," +
//                "垛田镇," +
//                "城东镇," +
//                "中堡镇," +
//                "安丰镇," +
//                "西郊镇," +
//                "永丰镇," +
//                "周奋乡," +
//                "茅山镇," +
//                "陶庄镇," +
//                "新垛镇," +
//                "大营镇," +
//                "海南镇," +
//                "陈堡镇," +
//                "临城镇," +
//                "戴南镇," +
//                "竹泓镇," +
//                "昌荣镇," +
//                "沈沦镇").split(","));
//
//
//        Set<String> result = Sets.newHashSet();
//        result.addAll(set1);
//        result.removeAll(set2);
//        for (String s : result) {
//            System.out.println(s);
//        }
//    }
}
