package suning.service.service;

import com.suning.api.entity.govbus.*;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Component;
import pool.dto.PicDto;
import pool.dto.ProviderCategoryDto;
import pool.dto.ProviderGoodsDto;
import pool.dto.ProviderGoodsParamsDto;
import suning.api.good.SnCategoryApi;
import suning.api.good.SnProductApi;
import suning.api.other.SnMessageApi;
import suning.api.price.SnPriceApi;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by Roney on 2017-04-09.
 */
@Component
public class SnMessageService {
    private final static Log log = Logs.getLog(SnMessageService.class.getName());



    @Autowired
    SnMessageApi snMessageApi;

    @Autowired
    SnCategoryApi snCategoryApi;

    @Autowired
    SnProductApi snProductApi;

    @Autowired
    SnPriceApi snPriceApi;

    public MessageGetResponse get(MessageGetRequest request) {
//        Map returnMap=new HashMap();
//        returnMap.put("result",;
        return snMessageApi.get(request);
    }

    public MessageDeleteResponse delete(MessageDeleteRequest request) {
      //  Map returnMap=new HashMap();
      //  returnMap.put("result",snMessageApi.delete(request));
        return snMessageApi.delete(request);
    }




    public ProviderGoodsDto MessageSnGoodsHandel(String sku) {

        ProviderGoodsDto goodsDto = new ProviderGoodsDto();
        ProdPoolQueryResponse.ResultInfo pool = new ProdPoolQueryResponse.ResultInfo();
        // 默认同步1普通商品
        pool.setCmmdtyType("1");
        pool.setSkuId(sku);
        ProdDetailGetRequest detailReq = new ProdDetailGetRequest();
        detailReq.setSkuId(sku);
        ProdDetailGetResponse detailRes = snProductApi.getProdDetail(detailReq);
        if (detailRes.getSnerror() == null) {
            ProdDetailGetResponse.GetProdDetail prodDetail = detailRes.getSnbody().getGetProdDetail();
            //商品图片
            ProdImageQueryRequest imageReq = new ProdImageQueryRequest();
            List<ProdImageQueryRequest.SkuIds> imageSkuIdses = new ArrayList<ProdImageQueryRequest.SkuIds>();
            ProdImageQueryRequest.SkuIds skuIds = new ProdImageQueryRequest.SkuIds();
            skuIds.setSkuId(prodDetail.getSkuId());
            imageSkuIdses.add(skuIds);
            imageReq.setSkuIds(imageSkuIdses);
            ProdImageQueryResponse imageRes = snProductApi.queryProdImage(imageReq);
            if (imageRes.getSnerror() != null) {
                throw new RuntimeException("同步商品图片出错，商品编号:" + pool.getSkuId());
            }
            ProdImageQueryResponse.ResultInfo imageResult = imageRes.getSnbody().getQueryProdImage().getResultInfo().get(0);
            //商品上下架状态
            BatchProdSaleStatusGetRequest batchProdSaleStatusGetRequest = new BatchProdSaleStatusGetRequest();
            List<BatchProdSaleStatusGetRequest.SkuIds> batchSkuidses = new ArrayList<BatchProdSaleStatusGetRequest.SkuIds>();
            BatchProdSaleStatusGetRequest.SkuIds batchSkuids = new BatchProdSaleStatusGetRequest.SkuIds();
            batchSkuids.setSkuId(prodDetail.getSkuId());
            batchSkuidses.add(batchSkuids);
            batchProdSaleStatusGetRequest.setSkuIds(batchSkuidses);
            BatchProdSaleStatusGetResponse batchRes = snProductApi.getBatchProdSaleStatus(batchProdSaleStatusGetRequest);
            if (batchRes.getSnerror() != null) {
                throw new RuntimeException("同步商品上下架状态出错，商品编号:" + pool.getSkuId());
            }
            BatchProdSaleStatusGetResponse.OnShelvesList onShelvesList = batchRes.getSnbody().getGetBatchProdSaleStatus().getOnShelvesList().get(0);

            PriceQueryRequest priceReq = new PriceQueryRequest();
            PriceQueryRequest.Skus priceSkus = new PriceQueryRequest.Skus();
            priceSkus.setSkuId(pool.getSkuId());
            priceReq.setSkus(Arrays.asList(priceSkus));
            String cityId = "010";
            //默认一个地址，先算出苏宁价格，方便走索引
            priceReq.setCityId(cityId);
            PriceQueryResponse priceRes = snPriceApi.queryPrice(priceReq);
            if (priceRes.getSnerror() != null) {
                cityId = "021";
                priceReq.setCityId(cityId);
                priceRes = snPriceApi.queryPrice(priceReq);
                if (priceRes.getSnerror() != null) {
                    System.out.println(priceRes.getSnerror().getErrorMsg());
                    throw new RuntimeException("同步商品价格出错，商品编号:" + pool.getSkuId());
                }
            }
            Boolean canSale = true;
            //发票类型 1：增票、普票 2：增票 3：普票 4：都不支持
            String invvoiceType ="1";

            /***
             * 查询商品是否支持开增值税发票
             */
            ProdextendGetRequest pgr = new ProdextendGetRequest();
            ProdextendGetRequest.Skus prodExtSkus = new ProdextendGetRequest.Skus();
            prodExtSkus.setSkuId(pool.getSkuId());
            pgr.setSkus(Arrays.asList(prodExtSkus));
            ProdextendGetResponse prodextendGetResponse = snProductApi.getProdextend(pgr);
            if (!Lang.isEmpty(prodextendGetResponse) && !Lang.isEmpty(prodextendGetResponse.getSnbody()) && !Lang.isEmpty(prodextendGetResponse.getSnbody().getGetProdextend())) {
                if (prodextendGetResponse.getSnbody().getGetProdextend().getIsSuccess().equals("Y")) {
                    if (prodextendGetResponse.getSnbody().getGetProdextend().getResultInfo().get(0).getIncreaseTicket().equals("02")) {
                        invvoiceType = "4";
                        canSale=false;
                    }
                }
            }

            PriceQueryResponse.Skus priceResSkus = priceRes.getSnbody().getQueryPrice().getSkus().get(0);
            if (Lang.isEmpty(priceResSkus.getPrice()) || Lang.isEmpty(priceResSkus.getSnPrice())) {
                canSale=false;
            }

            /**
             * 查询是否厂家配送
             * start
             */
            Boolean isJudgefac = true;
            JudgefacproductGetRequest jgr = new JudgefacproductGetRequest();
            jgr.setCityId(cityId);
            JudgefacproductGetRequest.SkuIds jgrSkuIds = new JudgefacproductGetRequest.SkuIds();
            jgrSkuIds.setSkuId(pool.getSkuId());
            jgr.setSkuIds(Arrays.asList(jgrSkuIds));
            JudgefacproductGetResponse getJudgefacProduct = snProductApi.getJudgefacProduct(jgr);
            if (!Lang.isEmpty(getJudgefacProduct) && !Lang.isEmpty(getJudgefacProduct.getSnbody())
                    && !Lang.isEmpty(getJudgefacProduct.getSnbody().getGetJudgefacproduct())) {
                if (!Lang.isEmpty(getJudgefacProduct.getSnbody().getGetJudgefacproduct().getIsSuccess())) {
                    if (getJudgefacProduct.getSnbody().getGetJudgefacproduct().getIsSuccess().equals("Y")) {
                        //是否厂送商品 01-是；02-否 当isSuccess=Y时必填
                        if (getJudgefacProduct.getSnbody().getGetJudgefacproduct().getResults().get(0).getIsFactorySend().equals("02")) {
                            isJudgefac = false;
                        }
                    }
                }
            }


            goodsDto.setSku(prodDetail.getSkuId());
            if (!Lang.isEmpty(priceResSkus)) {
                goodsDto.setCostPrice(Lang.isEmpty(priceResSkus.getPrice()) ? null : new BigDecimal(priceResSkus.getPrice()));
                goodsDto.setMarketPrice(Lang.isEmpty(priceResSkus.getSnPrice()) ? null : new BigDecimal(priceResSkus.getPrice()));
                goodsDto.setDiscountRate(Lang.isEmpty(priceResSkus.getDiscountRate()) ? null : new BigDecimal(priceResSkus.getDiscountRate()));
            }
            goodsDto.setWeight(prodDetail.getWeight());
            goodsDto.setName(prodDetail.getName());
            goodsDto.setSaleUnit(prodDetail.getSaleUnit());
            goodsDto.setUpc(prodDetail.getUpc());
            goodsDto.setIntroduction(prodDetail.getIntroduction());
            goodsDto.setProductArea(prodDetail.getProductArea());
            goodsDto.setStatus(String.valueOf(prodDetail.getState()));
            goodsDto.setIsJudgefac(isJudgefac);
//                goodsDto.setWareQD(prodDetail.getWareQD());
//                goodsDto.setParam(productDetail.getParam());
            //发票类型 1：增票、普票 2：增票 3：普票 4：都不支持
            goodsDto.setInvoiceType(invvoiceType);
            //是否支持售后 0,1
            goodsDto.setPostSalePolicy("1");

            List<ProviderGoodsParamsDto> goodsParamses = new ArrayList<ProviderGoodsParamsDto>();
            if (!Lang.isEmpty(prodDetail.getProdParams())) {
                for (ProdDetailGetResponse.ProdParams prodParams : prodDetail.getProdParams()) {
                    for (ProdDetailGetResponse.Param param : prodParams.getParam()) {
                        ProviderGoodsParamsDto goodsParams = new ProviderGoodsParamsDto();
                        goodsParams.setParamDesc(prodParams.getDesc());
                        goodsParams.setCoreFlag(param.getCoreFlag());
                        goodsParams.setCategory(prodDetail.getCategory());
                        goodsParams.setSnparameterVal(param.getSnparameterVal());
                        goodsParams.setSnparameterCode(param.getSnparameterCode());
                        goodsParams.setSnsequence(param.getSnsequence());
                        goodsParams.setSnparameterdesc(param.getSnparameterdesc());
                        goodsParams.setSnparametersCode(param.getSnparametersCode());
                        goodsParams.setSnparametersDesc(param.getSnparametersDesc());
                        goodsParams.setSnparameterSequence(param.getSnparameterSequence());
                        goodsParamses.add(goodsParams);
                    }
                }

                goodsDto.setProviderGoodsParamsDtos(goodsParamses);
            }

            List<PicDto> pics = new ArrayList<>();
            if (!Lang.isEmpty(imageResult) && !Lang.isEmpty(imageResult.getUrls())) {
                for (ProdImageQueryResponse.Urls urls : imageResult.getUrls()) {
                    PicDto pic = new PicDto();
                    pic.setPath(urls.getPath());
                    pic.setIsPrimary(urls.getPrimary());
                    pics.add(pic);
                }
            }
            goodsDto.setPics(pics);
            goodsDto.setOnSale(canSale);
            ProviderCategoryDto pcd = new ProviderCategoryDto();
            String catId = detailRes.getSnbody().getGetProdDetail().getCategory();
            CategoryGetResponse cgr = snCategoryApi.getCategory(new CategoryGetRequest());
            CategoryGetResponse.ResultInfo categoryResult = null;

            if (cgr.getSnerror() == null) {
                List<CategoryGetResponse.ResultInfo> snCatList = cgr.getSnbody().getGetCategory().getResultInfo();
                for (CategoryGetResponse.ResultInfo snCat : snCatList) {
                    if (snCat.getCategoryId().equals(catId)) {
                        categoryResult = snCat;
                        break;
                    }
                }
            }

            pcd.setThdLevelName(categoryResult.getCategoryName());
            pcd.setThdLevelCode(categoryResult.getCategoryId());
            goodsDto.setProviderCategoryDto(pcd);
            goodsDto.setBrandName(prodDetail.getBrand());

        }
        return goodsDto;

    }


}
