package suning.service.service;

import com.suning.api.entity.govbus.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import suning.api.order.SnOrderApi;
import utils.log.Log;
import utils.log.Logs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-09.
 */
@Component
public class SnOrderService {
    private final static Log log = Logs.getLog(SnOrderService.class.getName());

    public static final String RETURN_MAP_KEY_RESULT = "result";

    @Autowired
    SnOrderApi snOrderApi;

    public Map addOrder(OrderAddRequest request) {
        Map returnMap=new HashMap();
        returnMap.put(RETURN_MAP_KEY_RESULT,snOrderApi.addOrder(request));
        return returnMap;
    }

    public Map addConfirmOrder(ConfirmOrderAddRequest request) {
        Map returnMap=new HashMap();
        returnMap.put(RETURN_MAP_KEY_RESULT,snOrderApi.addConfirmOrder(request));
        return returnMap;
    }

    public Map deleteRejectOrder(RejectOrderDeleteRequest request) {
        Map returnMap=new HashMap();
        returnMap.put(RETURN_MAP_KEY_RESULT,snOrderApi.deleteRejectOrder(request));
        return returnMap;
    }

    public Map addApplyRejected(ApplyRejectedAddRequest request) {
        Map returnMap=new HashMap();
        returnMap.put(RETURN_MAP_KEY_RESULT,snOrderApi.addApplyRejected(request));
        return returnMap;
    }

    public Map getOrderDetail(OrderDetailGetRequest request) {
        Map returnMap=new HashMap();
        returnMap.put(RETURN_MAP_KEY_RESULT,snOrderApi.getOrderDetail(request));
        return returnMap;
    }

    public OrderStatusGetResponse getOrderStatus(OrderStatusGetRequest request) {
       // Map returnMap=new HashMap();
       // returnMap.put(RETURN_MAP_KEY_RESULT,snOrderApi.getOrderStatus(request));
        return snOrderApi.getOrderStatus(request);
    }

}
