package suning.service.service;

import com.suning.api.entity.govbus.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import suning.api.shipping.SnShippingApi;
import utils.log.Log;
import utils.log.Logs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-09.
 */
@Component
public class SnShippingService {
    private final static Log log = Logs.getLog(SnShippingService.class.getName());

    @Autowired
    SnShippingApi snShippingApi;

    public Map getOrderLogist(OrderLogistGetRequest request) {
        Map returnMap=new HashMap();
        returnMap.put("result",snShippingApi.getOrderLogist(request));
        return returnMap;
    }

    /**
     * suning.govbus.orderlogist.get 获取订单物流详情(新版)
     * @param request
     * @return
     */
    public Map getOrderLogistNew(OrderlogistnewGetRequest request) {
        Map returnMap=new HashMap();
        returnMap.put("result",snShippingApi.getOrderLogistNew(request));
        return returnMap;
    }

    public Map getShipTime(ShipTimeGetRequest request) {
        Map returnMap=new HashMap();
        returnMap.put("result",snShippingApi.getShipTime(request));
        return returnMap;
    }

    public Map getShipCarriage(ShipCarriageGetRequest request) {
        Map returnMap=new HashMap();
        returnMap.put("result",snShippingApi.getShipCarriage(request));
        return returnMap;
    }

    public Map confirmFacProduct(FacProductConfirmRequest request) {
        Map returnMap=new HashMap();
        returnMap.put("result",snShippingApi.confirmFacProduct(request));
        return returnMap;
    }


}
