package suning.service.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.suning.api.entity.govbus.InventoryGetRequest;
import com.suning.api.entity.govbus.InventoryGetResponse;
import com.suning.api.entity.govbus.MpStockQueryRequest;
import com.suning.api.entity.govbus.MpStockQueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import suning.api.stock.SnStockApi;
import utils.log.Log;
import utils.log.Logs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017-04-09.
 */
@Component
public class SnStockService {
    private final static Log log = Logs.getLog(SnStockService.class.getName());

    @Autowired
    SnStockApi snStockApi;

    public Map getInventory(InventoryGetRequest request) {
        Map returnMap=new HashMap();
        returnMap.put("result", snStockApi.getInventory(request));
        return returnMap;
    }

    public Map queryMprodStock(MpStockQueryRequest request){
        Map returnMap=new HashMap();
        returnMap.put("result", snStockApi.queryMprodStock(request));
        return returnMap;
    }

    public List<Map<String,String>> queryGoodsMprodStock(List<Map<String,String>> params ,String cityId){
        Map<String,String> resultMap = new HashMap<>();
        List<Map<String,String>> resultList = new ArrayList<Map<String,String>>();
        MpStockQueryRequest request = new MpStockQueryRequest();
        List<MpStockQueryRequest.SkuIds> skuIdses = new ArrayList<MpStockQueryRequest.SkuIds>();
        request.setCityId(cityId);
        int arraySize = params.size();
        for (int i = 0; i < arraySize; i++){
            MpStockQueryRequest.SkuIds skuIds = new MpStockQueryRequest.SkuIds();
            skuIds.setSkuId(params.get(i).get("skuId"));
            skuIdses.add(skuIds);
            if(i != 0 && i % 49 == 0 || arraySize-1 == i){
                request.setSkuIds(skuIdses);
                MpStockQueryResponse response = snStockApi.queryMprodStock(request);
                if(response.getSnerror()!=null){
                    return null;
                }
                List<MpStockQueryResponse.ResultInfo> resultInfos = response.getSnbody().getQueryMpStock().getResultInfo();
                for (MpStockQueryResponse.ResultInfo resultInfo :resultInfos){
                    Map<String,String> map = new HashMap<>();
                    map.put("skuId",resultInfo.getSkuId());
                    map.put("state",resultInfo.getState());
                    resultList.add(map);
                }
                skuIdses.clear();
            }
        }
        return resultList;
    }

    public List<Map<String,String>> getGoodsInventory(List<Map<String,String>> params ,String cityId,String countyId){
        Map<String,String> map = new HashMap<>();
        InventoryGetRequest request = new InventoryGetRequest();
        List<InventoryGetRequest.SkuIds> skuIdses = new ArrayList<InventoryGetRequest.SkuIds>();
        request.setCityId(cityId);
        request.setCountyId(countyId);
        int arraySize = params.size();
        List<Map<String,String>> resultList = new ArrayList<Map<String,String>>();
        for (int i = 0; i < arraySize; i++){
            InventoryGetRequest.SkuIds skuIds = new InventoryGetRequest.SkuIds();
            skuIds.setSkuId(params.get(i).get("skuId"));
            skuIds.setNum(params.get(i).get("num"));
            skuIdses.add(skuIds);
            if(i != 0 && i % 19 == 0 || arraySize-1 == i){
                request.setSkuIds(skuIdses);
                InventoryGetResponse response = snStockApi.getInventory(request);
                if(response.getSnerror()!=null){
                    return null;
                }
                List<InventoryGetResponse.ResultInfo> resultInfos = response.getSnbody().getGetInventory().getResultInfo();
                for (InventoryGetResponse.ResultInfo resultInfo :resultInfos){
                    Map<String,String> resultMap = new HashMap<>();
                    resultMap.put("skuId",resultInfo.getSkuId());
                    resultMap.put("state",resultInfo.getState());
                    resultList.add(resultMap);
                }
                skuIdses.clear();
            }
        }
        return resultList;
    }

//    public static void main(String[] args) {
//        List<Map<Integer,Integer>> list = new ArrayList<Map<Integer,Integer>>();
//
//        int i = 50;
//        for (int j = 1;j<=50;j++){
//            Map<Integer,Integer> map = new HashMap<>();
//            map.put(j,j);
//            list.add(map);
//        }
//        list.get(10).put(11,13);
//        System.out.println(JSONArray.toJSONString(list));
//    }

}
